/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.collection;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.common.smartcollection.ArrayWritable;
import net.automatalib.common.util.collection.CharStringRangeIterator;
import net.automatalib.common.util.collection.IntRange;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CharStringRange
extends AbstractList<String>
implements ArrayWritable<String>,
RandomAccess {
    private final IntRange delegate;

    public CharStringRange(char low, char high) {
        this(low, high, 1);
    }

    public CharStringRange(char low, char high, int step) {
        this(new IntRange(low, high, step));
    }

    public CharStringRange(IntRange delegate) {
        this.delegate = delegate;
    }

    @Override
    public String get(int index) {
        return String.valueOf(this.charGet(index));
    }

    public char charGet(int index) {
        return (char)this.delegate.intGet(index);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null || o.getClass() != String.class) {
            return -1;
        }
        return this.indexOf((String)o);
    }

    public int indexOf(String s) {
        if (s.length() != 1) {
            return -1;
        }
        return this.delegate.indexOf(s.charAt(0));
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.indexOf(o);
    }

    public CharStringRangeIterator iterator() {
        return new CharStringRangeIterator(this.delegate.iterator());
    }

    public CharStringRangeIterator listIterator() {
        return new CharStringRangeIterator(this.delegate.listIterator());
    }

    public CharStringRangeIterator listIterator(int index) {
        return new CharStringRangeIterator(this.delegate.listIterator(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        int si = offset;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = this.get(si++);
        }
    }
}

