/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.serialization.saf.SAFInput;
import net.automatalib.serialization.saf.SAFOutput;
import net.automatalib.words.Alphabet;

public final class SAFSerializationNFA
implements InputModelSerializationProvider<Integer, NFA<?, Integer>, NFA<Integer, Integer>> {
    private static final SAFSerializationNFA INSTANCE = new SAFSerializationNFA();

    private SAFSerializationNFA() {
    }

    public static SAFSerializationNFA getInstance() {
        return INSTANCE;
    }

    public InputModelData<Integer, NFA<Integer, Integer>> readModel(InputStream is) throws IOException {
        InputStream uncompressedStream = IOUtil.asUncompressedInputStream((InputStream)is);
        SAFInput in = new SAFInput(uncompressedStream);
        CompactNFA<Integer> automaton = in.readNativeNFA();
        return new InputModelData(automaton, automaton.getInputAlphabet());
    }

    public void writeModel(OutputStream os, NFA<?, Integer> model, Alphabet<Integer> alphabet) throws IOException {
        SAFOutput out = new SAFOutput(os);
        out.writeNFA(model, alphabet);
    }
}

