/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.automaton.fsa.NFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.serialization.saf.SAFInput;
import net.automatalib.serialization.saf.SAFOutput;

public final class SAFSerializationNFA
implements InputModelSerializationProvider<Integer, NFA<?, Integer>, NFA<Integer, Integer>> {
    private static final SAFSerializationNFA INSTANCE = new SAFSerializationNFA();

    private SAFSerializationNFA() {
    }

    public static SAFSerializationNFA getInstance() {
        return INSTANCE;
    }

    public InputModelData<Integer, NFA<Integer, Integer>> readModel(InputStream is) throws IOException {
        try (InputStream stream = IOUtil.asUncompressedBufferedNonClosingInputStream((InputStream)is);){
            SAFInput in = new SAFInput(stream);
            CompactNFA<Integer> automaton = in.readNativeNFA();
            InputModelData inputModelData = new InputModelData(automaton, automaton.getInputAlphabet());
            return inputModelData;
        }
    }

    public void writeModel(OutputStream os, NFA<?, Integer> model, Alphabet<Integer> alphabet) throws IOException {
        SAFOutput out = new SAFOutput(os);
        out.writeNFA(model, alphabet);
    }
}

