/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.learnlibv2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Scanner;
import javax.annotation.WillNotClose;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class LearnLibV2Serialization
implements InputModelSerializationProvider<Integer, DFA<?, Integer>, DFA<Integer, Integer>> {
    private static final LearnLibV2Serialization INSTANCE = new LearnLibV2Serialization();

    public static LearnLibV2Serialization getInstance() {
        return INSTANCE;
    }

    public void writeModel(OutputStream os, DFA<?, Integer> model, Alphabet<Integer> alphabet) {
        this.doWriteDFA(model, alphabet, os);
    }

    public <I> void writeGenericModel(OutputStream os, DFA<?, I> model, Alphabet<I> alphabet) {
        this.doWriteDFA(model, alphabet, os);
    }

    public InputModelData<Integer, DFA<Integer, Integer>> readModel(InputStream is) throws IOException {
        CompactDFA<Integer> automaton = this.readGenericDFA(is);
        return new InputModelData(automaton, automaton.getInputAlphabet());
    }

    public CompactDFA<Integer> readGenericDFA(@WillNotClose InputStream is) throws IOException {
        int i;
        Scanner sc = new Scanner(IOUtil.asUncompressedInputStream((InputStream)is), StandardCharsets.UTF_8.toString());
        int numStates = sc.nextInt();
        int numSymbols = sc.nextInt();
        Alphabet alphabet = Alphabets.integers((int)0, (int)(numSymbols - 1));
        CompactDFA result = new CompactDFA(alphabet, numStates);
        int[] states = new int[numStates];
        states[0] = result.addIntInitialState((Object)(sc.nextInt() != 0 ? 1 : 0));
        for (i = 1; i < numStates; ++i) {
            states[i] = result.addIntState((Object)(sc.nextInt() != 0 ? 1 : 0));
        }
        for (i = 0; i < numStates; ++i) {
            int state = states[i];
            for (int j = 0; j < numSymbols; ++j) {
                int succ = states[sc.nextInt()];
                result.setTransition(state, j, succ);
            }
        }
        return result;
    }

    private <S, I> void doWriteDFA(DFA<S, I> dfa, Alphabet<I> alphabet, OutputStream os) {
        PrintStream ps;
        int numDfaStates;
        boolean partial = Automata.hasUndefinedInput(dfa, alphabet);
        int numStates = numDfaStates = dfa.size();
        if (partial) {
            ++numStates;
        }
        try {
            ps = new PrintStream(os, false, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        int numInputs = alphabet.size();
        ps.printf("%d %d%n", numStates, numInputs);
        StateIDs stateIds = dfa.stateIDs();
        Object initState = dfa.getInitialState();
        int initId = stateIds.getStateId(initState);
        ArrayList<Object> orderedStates = new ArrayList<Object>(numDfaStates);
        orderedStates.add(initState);
        ps.printf("%d ", dfa.isAccepting(initState) ? 1 : 0);
        for (int i = 1; i < numDfaStates; ++i) {
            Object state = stateIds.getState(i);
            if (i == initId) {
                state = stateIds.getState(0);
            }
            ps.printf("%d ", dfa.isAccepting(state) ? 1 : 0);
            orderedStates.add(state);
        }
        if (partial) {
            ps.print("0");
        }
        ps.println();
        for (Object state : orderedStates) {
            for (Object sym : alphabet) {
                Object target = dfa.getSuccessor(state, sym);
                int targetId = numDfaStates;
                if (target != null) {
                    targetId = stateIds.getStateId(target);
                    if (targetId == initId) {
                        targetId = 0;
                    } else if (targetId == 0) {
                        targetId = initId;
                    }
                }
                ps.printf("%d ", targetId);
            }
            ps.println();
        }
        if (partial) {
            for (int i = 0; i < numInputs; ++i) {
                ps.printf("%d ", numDfaStates);
            }
            ps.println();
        }
    }
}

