/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.fsm.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.automatalib.common.util.Pair;
import net.automatalib.serialization.fsm.parser.AbstractFSM2MealyParser;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FSM2MealyParserIO<I, O>
extends AbstractFSM2MealyParser<I, O> {
    private FSM2MealyParserIO(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser, Function<String, O> outputParser) {
        super(targetInputs, inputParser, outputParser);
    }

    @Override
    protected void parseTransition(StreamTokenizer streamTokenizer) throws IOException {
        try {
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int from = Integer.parseInt(streamTokenizer.sval);
            if (!this.getStates().isEmpty() && !this.getStates().contains(from)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", from), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int to = Integer.parseInt(streamTokenizer.sval);
            if (!this.getStates().isEmpty() && !this.getStates().contains(to)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", to), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != 34) {
                throw new FSMFormatException("expecting string", streamTokenizer);
            }
            Object input = this.getInputParser().apply(streamTokenizer.sval);
            this.getInputs().add(input);
            if (streamTokenizer.nextToken() != 34) {
                throw new FSMFormatException("expecting string", streamTokenizer);
            }
            Object output = this.getOutputParser().apply(streamTokenizer.sval);
            Pair prev = this.getTransitions().put(Pair.of((Object)from, input), Pair.of(output, (Object)to));
            if (prev != null) {
                throw new FSMFormatException(String.format("non-determinism detected (previous value: %s)", prev), streamTokenizer);
            }
        }
        catch (NumberFormatException nfe) {
            throw new FSMFormatException(nfe, streamTokenizer);
        }
    }

    @Override
    protected void checkTransitions(StreamTokenizer streamTokenizer) {
        if (this.getStates().isEmpty()) {
            this.getStates().addAll(this.getTransitions().keySet().stream().map(Pair::getFirst).collect(Collectors.toList()));
        }
    }

    public static <I, O> FSM2MealyParserIO<I, O> getParser(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser, Function<String, O> outputParser) {
        return new FSM2MealyParserIO<I, O>(targetInputs, inputParser, outputParser);
    }

    public static <I, O> FSM2MealyParserIO<I, O> getParser(Function<String, I> inputParser, Function<String, O> outputParser) {
        return FSM2MealyParserIO.getParser(null, inputParser, outputParser);
    }

    public static <E> FSM2MealyParserIO<E, E> getParser(@Nullable Collection<? extends E> targetInputs, Function<String, E> edgeParser) {
        return FSM2MealyParserIO.getParser(targetInputs, edgeParser, edgeParser);
    }

    public static <E> FSM2MealyParserIO<E, E> getParser(Function<String, E> edgeParser) {
        return FSM2MealyParserIO.getParser(edgeParser, edgeParser);
    }
}

