/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.fsm.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.serialization.ModelDeserializer;
import net.automatalib.serialization.fsm.parser.AbstractFSMParser;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FSM2DFAParser<I>
extends AbstractFSMParser<I>
implements ModelDeserializer<CompactDFA<I>> {
    public static final String ACCEPT_NOT_FOUND = "accepting state label (%s) not found";
    public static final String ACCEPT_VALUE_NOT_FOUND = "accepting state label value (%s) not found";
    public static final String ACCEPT_INDEX_NOT_FOUND = "index for accepting state label (%d) not found";
    private int acceptIndex = -1;
    private int acceptValue = -1;
    private final SortedMap<Integer, Boolean> states = new TreeMap<Integer, Boolean>();
    private final Map<Pair<Integer, I>, Integer> transitions = new HashMap<Pair<Integer, I>, Integer>();
    private final String acceptingDataVariableName;
    private final String acceptingDataValue;

    private FSM2DFAParser(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser, String acceptingDataVariableName, String acceptingDataValue) {
        super(targetInputs, inputParser);
        this.acceptingDataVariableName = acceptingDataVariableName;
        this.acceptingDataValue = acceptingDataValue;
    }

    @Override
    protected void parseDataDefinition(StreamTokenizer streamTokenizer) throws IOException {
        if (this.acceptIndex == -1 && this.acceptValue == -1) {
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("expecting identifier", streamTokenizer);
            }
            String dataVariableName = streamTokenizer.sval;
            if (this.acceptingDataVariableName.equals(dataVariableName)) {
                this.acceptIndex = this.getPartLineNumber();
                if (streamTokenizer.nextToken() != 40) {
                    throw new FSMFormatException(String.format("expected char '%c' not found", Character.valueOf('(')), streamTokenizer);
                }
                if (streamTokenizer.nextToken() != -3) {
                    throw new FSMFormatException("number expected", streamTokenizer);
                }
                if (streamTokenizer.nextToken() != 41) {
                    throw new FSMFormatException(String.format("expected char '%c' not found", Character.valueOf(')')), streamTokenizer);
                }
                if (streamTokenizer.nextToken() != -3) {
                    throw new FSMFormatException("expecting identifier", streamTokenizer);
                }
                int dataValueIndex = 0;
                while (streamTokenizer.nextToken() == 34 && this.acceptValue == -1) {
                    String dataValue = streamTokenizer.sval;
                    if (this.acceptingDataValue.equals(dataValue)) {
                        this.acceptValue = dataValueIndex;
                        continue;
                    }
                    ++dataValueIndex;
                }
                streamTokenizer.pushBack();
                if (this.acceptValue == -1) {
                    throw new FSMFormatException(String.format(ACCEPT_VALUE_NOT_FOUND, this.acceptingDataValue), streamTokenizer);
                }
            }
        }
    }

    @Override
    protected void checkDataDefinitions(StreamTokenizer streamTokenizer) {
        if (this.acceptIndex == -1) {
            throw new FSMFormatException(String.format(ACCEPT_NOT_FOUND, this.acceptingDataVariableName), streamTokenizer);
        }
    }

    @Override
    protected void parseStateVector(StreamTokenizer streamTokenizer) throws IOException {
        Boolean accepting = null;
        for (int i = 0; i <= this.acceptIndex && streamTokenizer.nextToken() == -3 && accepting == null; ++i) {
            if (i != this.acceptIndex) continue;
            try {
                accepting = this.acceptValue == Integer.parseInt(streamTokenizer.sval);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new FSMFormatException(nfe, streamTokenizer);
            }
        }
        if (accepting == null) {
            throw new FSMFormatException(String.format(ACCEPT_INDEX_NOT_FOUND, this.acceptIndex), streamTokenizer);
        }
        this.states.put(this.getPartLineNumber(), accepting);
    }

    @Override
    protected void checkStateVectors(StreamTokenizer streamTokenizer) {
    }

    @Override
    protected void parseTransition(StreamTokenizer streamTokenizer) throws IOException {
        try {
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int from = Integer.parseInt(streamTokenizer.sval);
            if (!this.states.isEmpty() && !this.states.containsKey(from)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", from), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int to = Integer.parseInt(streamTokenizer.sval);
            if (!this.states.isEmpty() && !this.states.containsKey(to)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", to), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != 34) {
                throw new FSMFormatException("expecting string", streamTokenizer);
            }
            Object input = this.getInputParser().apply(streamTokenizer.sval);
            this.getInputs().add(input);
            Integer prev = this.transitions.put(Pair.of((Object)from, input), to);
            if (prev != null) {
                throw new FSMFormatException(String.format("non-determinism detected (previous value: %s)", prev), streamTokenizer);
            }
        }
        catch (NumberFormatException nfe) {
            throw new FSMFormatException(nfe, streamTokenizer);
        }
    }

    @Override
    protected void checkTransitions(StreamTokenizer streamTokenizer) {
        if (this.states.isEmpty()) {
            this.transitions.keySet().forEach(e -> this.states.put((Integer)e.getFirst(), true));
        }
    }

    private CompactDFA<I> parseDFA(Reader reader) throws IOException {
        this.parse(reader);
        Alphabet alphabet = this.targetInputs != null ? Alphabets.fromCollection((Collection)this.targetInputs) : Alphabets.fromCollection(this.getInputs());
        CompactDFA dfa = new CompactDFA(alphabet);
        this.states.forEach((key, value) -> dfa.addState(value));
        dfa.setInitialState(this.states.firstKey() - 1);
        this.transitions.entrySet().stream().filter(e -> alphabet.containsSymbol(((Pair)e.getKey()).getSecond())).forEach(e -> dfa.addTransition((Object)((Integer)((Pair)e.getKey()).getFirst() - 1), ((Pair)e.getKey()).getSecond(), (Object)((Integer)e.getValue() - 1)));
        this.states.clear();
        this.transitions.clear();
        return dfa;
    }

    public CompactDFA<I> readModel(InputStream is) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader((InputStream)is);){
            CompactDFA<I> compactDFA = this.parseDFA(r);
            return compactDFA;
        }
    }

    public static <I> FSM2DFAParser<I> getParser(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser, String acceptingDataVariableName, String acceptingDataValue) {
        return new FSM2DFAParser<I>(targetInputs, inputParser, acceptingDataVariableName, acceptingDataValue);
    }

    public static <I> FSM2DFAParser<I> getParser(Function<String, I> inputParser, String acceptingDataVariableName, String acceptingDataValue) {
        return FSM2DFAParser.getParser(null, inputParser, acceptingDataVariableName, acceptingDataValue);
    }
}

