/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.etf.writer;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.serialization.etf.writer.AbstractETFWriter;

public final class Mealy2ETFWriterAlternating<I, O>
extends AbstractETFWriter<I, MealyMachine<?, I, ?, O>> {
    private static final Mealy2ETFWriterAlternating<?, ?> INSTANCE = new Mealy2ETFWriterAlternating();

    private Mealy2ETFWriterAlternating() {
    }

    @Override
    protected void writeEdge(PrintWriter pw) {
        pw.println("begin edge");
        pw.println("letter:letter");
        pw.println("end edge");
    }

    @Override
    protected void writeETF(PrintWriter pw, MealyMachine<?, I, ?, O> mealy, Alphabet<I> inputs) {
        this.writeETFInternal(pw, mealy, inputs);
    }

    private <S, T> void writeETFInternal(PrintWriter pw, MealyMachine<S, I, T, O> mealy, Alphabet<I> inputs) {
        StateIDs oldStateIDs = mealy.stateIDs();
        Object init = mealy.getInitialState();
        pw.println("begin init");
        if (init != null) {
            pw.printf("%d%n", oldStateIDs.getStateId(init));
        }
        pw.println("end init");
        LinkedHashMap<Pair, Integer> outputTransitions = new LinkedHashMap<Pair, Integer>();
        LinkedHashMap outputIndices = new LinkedHashMap();
        pw.println("begin trans");
        for (Object s : mealy.getStates()) {
            for (Object i2 : inputs) {
                Object t = mealy.getTransition(s, i2);
                if (t == null) continue;
                Object n = mealy.getSuccessor(t);
                Object o = mealy.getTransitionOutput(t);
                Pair outputTransition = Pair.of((Object)o, (Object)n);
                Integer intermediateState = outputTransitions.computeIfAbsent(outputTransition, ii -> {
                    Integer outputIndex = outputIndices.computeIfAbsent(o, iii -> inputs.size() + outputIndices.size());
                    Integer res = mealy.size() + outputTransitions.size();
                    pw.printf("%d/%d %d%n", res, oldStateIDs.getStateId(n), outputIndex);
                    return res;
                });
                pw.printf("%d/%d %d%n", oldStateIDs.getStateId(s), intermediateState, inputs.getSymbolIndex(i2));
            }
        }
        pw.println("end trans");
        pw.println("begin sort id");
        for (int i3 = 0; i3 < mealy.size(); ++i3) {
            pw.printf("\"%s\"%n", oldStateIDs.getState(i3));
        }
        for (Pair t : outputTransitions.keySet()) {
            pw.printf("\"(%s,%s)\"%n", t.getFirst(), t.getSecond());
        }
        pw.println("end sort");
        pw.println("begin sort letter");
        inputs.forEach(i -> pw.printf("\"%s\"%n", i));
        for (Object o : outputIndices.keySet()) {
            pw.printf("\"%s\"%n", o);
        }
        pw.println("end sort");
    }

    public void writeModel(OutputStream os, MealyMachine<?, I, ?, O> model, Alphabet<I> alphabet) {
        try (PrintWriter pw = new PrintWriter(IOUtil.asNonClosingUTF8Writer((OutputStream)os));){
            this.write(pw, model, alphabet);
        }
    }

    public static <I, O> Mealy2ETFWriterAlternating<I, O> getInstance() {
        return INSTANCE;
    }
}

