/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.etf.writer;

import java.io.OutputStream;
import java.io.PrintWriter;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.etf.writer.AbstractETFWriter;

public final class DFA2ETFWriter<I>
extends AbstractETFWriter<I, DFA<?, I>> {
    private static final DFA2ETFWriter<?> INSTANCE = new DFA2ETFWriter();

    private DFA2ETFWriter() {
    }

    @Override
    protected void writeEdge(PrintWriter pw) {
        pw.println("begin edge");
        pw.println("letter:letter");
        pw.println("end edge");
    }

    @Override
    protected void writeETF(PrintWriter pw, DFA<?, I> dfa, Alphabet<I> inputs) {
        this.writeETFInternal(pw, dfa, inputs);
    }

    private <S> void writeETFInternal(PrintWriter pw, DFA<S, I> dfa, Alphabet<I> inputs) {
        StateIDs stateIDs = dfa.stateIDs();
        Object init = dfa.getInitialState();
        if (init != null) {
            pw.println("begin init");
            pw.printf("%d%n", stateIDs.getStateId(init));
            pw.println("end init");
        }
        pw.println("begin sort id");
        dfa.getStates().forEach(s -> pw.printf("\"%s\"%n", s));
        pw.println("end sort");
        pw.println("begin sort letter");
        for (Object i : inputs) {
            pw.print("\"");
            pw.print(i);
            pw.println("\"");
        }
        pw.println("end sort");
        pw.println("begin trans");
        for (Object s2 : dfa.getStates()) {
            for (Object i : inputs) {
                Object t = dfa.getSuccessor(s2, i);
                if (t == null) continue;
                pw.printf("%d/%d %d%n", stateIDs.getStateId(s2), stateIDs.getStateId(t), inputs.getSymbolIndex(i));
            }
        }
        pw.println("end trans");
        pw.println("begin sort label");
        pw.println("\"reject\"");
        pw.println("\"accept\"");
        pw.println("end sort");
        pw.println("begin map label:label");
        for (Object s2 : dfa.getStates()) {
            int stateId = stateIDs.getStateId(s2);
            pw.printf("%d %d%n", stateId, dfa.isAccepting(s2) ? 1 : 0);
        }
        pw.println("end map");
    }

    public void writeModel(OutputStream os, DFA<?, I> model, Alphabet<I> alphabet) {
        try (PrintWriter pw = new PrintWriter(IOUtil.asNonClosingUTF8Writer((OutputStream)os));){
            this.write(pw, model, alphabet);
        }
    }

    public static <I> DFA2ETFWriter<I> getInstance() {
        return INSTANCE;
    }
}

