/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.UndirectedGraph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.serialization.dot.AggregateDOTVisualizationHelper;
import net.automatalib.serialization.dot.DOTVisualizationHelper;
import net.automatalib.serialization.dot.DefaultDOTVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;

public final class GraphDOT {
    private GraphDOT() {
    }

    public static void write(GraphViewable gv, Appendable a) throws IOException {
        Graph graph = gv.graphView();
        GraphDOT.write(graph, a);
    }

    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        GraphDOT.write(automaton, inputAlphabet, a, Arrays.asList(additionalHelpers));
    }

    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, List<VisualizationHelper<S, ? super TransitionEdge<I, T>>> additionalHelpers) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a, additionalHelpers);
    }

    public static <N, E> void write(Graph<N, E> graph, Appendable a) throws IOException {
        GraphDOT.writeRaw(graph, a, GraphDOT.toDOTVisualizationHelper(graph.getVisualizationHelper()));
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, Appendable a, VisualizationHelper<N, ? super E> ... additionalHelpers) throws IOException {
        GraphDOT.write(graph, a, Arrays.asList(additionalHelpers));
    }

    public static <N, E> void write(Graph<N, E> graph, Appendable a, List<VisualizationHelper<N, ? super E>> additionalHelpers) throws IOException {
        ArrayList<VisualizationHelper<N, Object>> helpers = new ArrayList<VisualizationHelper<N, Object>>(additionalHelpers.size() + 1);
        helpers.add(graph.getVisualizationHelper());
        helpers.addAll(additionalHelpers);
        GraphDOT.writeRaw(graph, a, GraphDOT.toDOTVisualizationHelper(helpers));
    }

    private static <N, E> void writeRaw(Graph<N, E> graph, Appendable a, DOTVisualizationHelper<N, ? super E> dotHelperOrNull) throws IOException {
        boolean directed;
        DOTVisualizationHelper<N, ? super E> dotHelper = dotHelperOrNull == null ? new DefaultDOTVisualizationHelper<N, E>() : dotHelperOrNull;
        boolean bl = directed = !(graph instanceof UndirectedGraph);
        if (directed) {
            a.append("di");
        }
        a.append("graph g {").append(System.lineSeparator());
        HashMap<String, String> props = new HashMap<String, String>();
        dotHelper.getGlobalNodeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("node");
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
        }
        props.clear();
        dotHelper.getGlobalEdgeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("edge");
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
        }
        dotHelper.writePreamble(a);
        a.append(System.lineSeparator());
        MutableMapping nodeNames = graph.createStaticNodeMapping();
        HashSet<String> initialNodes = new HashSet<String>();
        int i = 0;
        for (Object node : graph) {
            props.clear();
            if (!dotHelper.getNodeProperties(node, props)) continue;
            String id = "s" + i++;
            if (Boolean.parseBoolean((String)props.remove("initial"))) {
                initialNodes.add(id);
            }
            props.remove("accepting");
            a.append('\t').append(id);
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
            nodeNames.put(node, (Object)id);
        }
        for (Object node : graph) {
            Collection outEdges;
            String srcId = (String)nodeNames.get(node);
            if (srcId == null || (outEdges = graph.getOutgoingEdges(node)).isEmpty()) continue;
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                String tgtId = (String)nodeNames.get(tgt);
                if (tgtId == null || !directed && tgtId.compareTo(srcId) < 0) continue;
                props.clear();
                if (!dotHelper.getEdgeProperties(node, e, tgt, props)) continue;
                a.append('\t').append(srcId).append(' ');
                if (directed) {
                    a.append("-> ");
                } else {
                    a.append("-- ");
                }
                a.append(tgtId);
                GraphDOT.appendParams(props, a);
                a.append(';').append(System.lineSeparator());
            }
        }
        a.append(System.lineSeparator());
        GraphDOT.renderInitialArrowTip(initialNodes, a);
        dotHelper.writePostamble(a);
        a.append(System.lineSeparator());
        a.append('}').append(System.lineSeparator());
        if (a instanceof Flushable) {
            ((Flushable)((Object)a)).flush();
        }
    }

    private static void appendParams(Map<String, String> params, Appendable a) throws IOException {
        if (params == null || params.isEmpty()) {
            return;
        }
        a.append(" [");
        boolean first = true;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                a.append(' ');
            }
            String key = e.getKey();
            String value = e.getValue();
            a.append(e.getKey()).append("=");
            String htmlTag = "<HTML>";
            if (key.equals("label") && value.toUpperCase().startsWith("<HTML>")) {
                a.append('<').append(value.substring("<HTML>".length())).append('>');
                continue;
            }
            StringUtil.enquote((String)e.getValue(), (Appendable)a);
        }
        a.append(']');
    }

    private static void renderInitialArrowTip(Set<String> initialNodes, Appendable a) throws IOException {
        String startPrefix = "__start";
        int i = 0;
        for (String init : initialNodes) {
            a.append("__start").append(Integer.toString(i)).append(" [label=\"\" shape=\"none\" width=\"0\" height=\"0\"];").append(System.lineSeparator()).append("__start").append(Integer.toString(i++)).append(" -> ").append(init).append(';').append(System.lineSeparator());
        }
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(VisualizationHelper<N, E> helper) {
        if (helper instanceof DOTVisualizationHelper) {
            return (DOTVisualizationHelper)helper;
        }
        return new DefaultDOTVisualizationHelper<N, E>(helper);
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(List<VisualizationHelper<N, ? super E>> helpers) {
        ArrayList<DOTVisualizationHelper<N, E>> convertedHelpers = new ArrayList<DOTVisualizationHelper<N, E>>(helpers.size());
        for (VisualizationHelper<N, E> visualizationHelper : helpers) {
            convertedHelpers.add(GraphDOT.toDOTVisualizationHelper(visualizationHelper));
        }
        return new AggregateDOTVisualizationHelper(convertedHelpers);
    }
}

