/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.common.util.string.StringUtil;
import net.automatalib.serialization.FormatException;
import net.automatalib.serialization.dot.Edge;
import net.automatalib.serialization.dot.InternalDOTParserConstants;
import net.automatalib.serialization.dot.InternalDOTParserTokenManager;
import net.automatalib.serialization.dot.Node;
import net.automatalib.serialization.dot.ParseException;
import net.automatalib.serialization.dot.SimpleCharStream;
import net.automatalib.serialization.dot.Token;

class InternalDOTParser
implements InternalDOTParserConstants {
    private Map<String, String> defaultNodeAttrs = new LinkedHashMap<String, String>();
    private Map<String, String> defaultEdgeAttrs = new LinkedHashMap<String, String>();
    private Map<String, Map<String, String>> nodes = new LinkedHashMap<String, Map<String, String>>();
    private Map<EdgePair, Map<String, String>> edges = new LinkedHashMap<EdgePair, Map<String, String>>();
    private boolean parsed;
    private boolean strict;
    private boolean directed;
    private List<Node> transformedNodes;
    private List<Edge> transformedEdges;
    public InternalDOTParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[26];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public List<Node> getNodes() {
        Preconditions.checkArgument((boolean)this.parsed, (Object)"parse() needs to be called first");
        return this.transformedNodes;
    }

    public List<Edge> getEdges() {
        Preconditions.checkArgument((boolean)this.parsed, (Object)"parse() needs to be called first");
        return this.transformedEdges;
    }

    public boolean isStrict() {
        Preconditions.checkArgument((boolean)this.parsed, (Object)"parse() needs to be called first");
        return this.strict;
    }

    public boolean isDirected() {
        Preconditions.checkArgument((boolean)this.parsed, (Object)"parse() needs to be called first");
        return this.directed;
    }

    public void parse() throws FormatException {
        try {
            this.graph();
        }
        catch (ParseException e) {
            throw new FormatException((Throwable)e);
        }
        this.parsed = true;
        ArrayList<Node> transformedNodes = new ArrayList<Node>(this.nodes.size());
        ArrayList<Edge> transformedEdges = new ArrayList<Edge>(this.edges.size());
        for (Map.Entry<String, Map<String, String>> entry : this.nodes.entrySet()) {
            transformedNodes.add(new Node(entry.getKey(), Collections.unmodifiableMap(entry.getValue())));
        }
        for (Map.Entry<Object, Map<String, String>> entry : this.edges.entrySet()) {
            transformedEdges.add(new Edge(((EdgePair)entry.getKey()).src, ((EdgePair)entry.getKey()).tgt, Collections.unmodifiableMap(entry.getValue())));
        }
        this.transformedNodes = Collections.unmodifiableList(transformedNodes);
        this.transformedEdges = Collections.unmodifiableList(transformedEdges);
        this.nodes = null;
        this.edges = null;
    }

    private void addEdges(List<EdgePair> edges, Map<String, String> attrs) {
        LinkedHashMap<String, String> localAttrs = new LinkedHashMap<String, String>(this.defaultEdgeAttrs);
        localAttrs.putAll(attrs);
        for (EdgePair ep : edges) {
            String src = ep.src;
            String tgt = ep.tgt;
            this.edges.put(ep, localAttrs);
            this.putIfAbsent(this.nodes, src, new LinkedHashMap<String, String>(this.defaultNodeAttrs));
            this.putIfAbsent(this.nodes, tgt, new LinkedHashMap<String, String>(this.defaultNodeAttrs));
        }
    }

    private <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
            return value;
        }
        return map.get(key);
    }

    private final void graph() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                this.strict = true;
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                this.directed = true;
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 25: 
            case 44: {
                this.identifier();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        this.stmt_list();
        this.jj_consume_token(14);
    }

    private final List<String> stmt_list() throws ParseException {
        ArrayList<String> allNodes = new ArrayList<String>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 20: 
                case 25: 
                case 44: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block6;
                }
            }
            List<String> nodes = this.stmt();
            allNodes.addAll(nodes);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    continue block6;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        return allNodes;
    }

    private final List<String> stmt() throws ParseException {
        ArrayList<String> nodes = new ArrayList<String>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 25: 
            case 44: {
                String id = this.identifier();
                nodes.add(id);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: {
                        List<String> edgeTgt = this.edge_stmt(id);
                        nodes.addAll(edgeTgt);
                        break block0;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.node_stmt(id);
                break;
            }
            case 10: 
            case 13: {
                List<String> graphSrc = this.subgraph();
                nodes.addAll(graphSrc);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: {
                        List<String> graphTgt = this.edge_stmt_sgr(graphSrc);
                        nodes.addAll(graphTgt);
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.attr_stmt();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return nodes;
    }

    private final void attr_stmt() throws ParseException {
        Map<String, String> defaults = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                defaults = this.defaultNodeAttrs;
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                defaults = this.defaultEdgeAttrs;
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.attr_list(defaults);
    }

    private final void attr_list(Map<String, String> attrs) throws ParseException {
        block6: while (true) {
            this.jj_consume_token(11);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: 
                case 25: 
                case 44: {
                    this.a_list(attrs);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[10] = this.jj_gen;
    }

    private final void a_list(Map<String, String> attrs) throws ParseException {
        block10: while (true) {
            String key = this.identifier();
            this.jj_consume_token(18);
            String value = this.identifier();
            if (attrs != null) {
                attrs.put(key, value);
            }
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 16: {
                            this.jj_consume_token(16);
                            break block0;
                        }
                        case 17: {
                            this.jj_consume_token(17);
                            break block0;
                        }
                    }
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: 
                case 25: 
                case 44: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[13] = this.jj_gen;
    }

    private final List<String> edge_stmt(String src) throws ParseException {
        ArrayList<EdgePair> edges = new ArrayList<EdgePair>();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        List<String> tgts = this.edgeRHS(Collections.singletonList(src), edges);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.attr_list(attrs);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.addEdges(edges, attrs);
        return tgts;
    }

    private final List<String> edge_stmt_sgr(List<String> srcs) throws ParseException {
        ArrayList<EdgePair> edges = new ArrayList<EdgePair>();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        List<String> tgts = this.edgeRHS(srcs, edges);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.attr_list(attrs);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.addEdges(edges, attrs);
        return tgts;
    }

    private final List<String> edgeRHS(List<String> srcs, List<EdgePair> edges) throws ParseException {
        ArrayList<String> nodes = new ArrayList<String>();
        block7: while (true) {
            List<String> tgts;
            this.jj_consume_token(19);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: 
                case 25: 
                case 44: {
                    String tgt = this.node_id();
                    tgts = Collections.singletonList(tgt);
                    break;
                }
                case 10: 
                case 13: {
                    tgts = this.subgraph();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            for (String s : srcs) {
                for (String t : tgts) {
                    edges.add(new EdgePair(s, t));
                }
            }
            nodes.addAll(tgts);
            srcs = tgts;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 19: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[17] = this.jj_gen;
        return nodes;
    }

    private final void node_stmt(String id) throws ParseException {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.attr_list(attrs);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Map localAttrs = this.putIfAbsent(this.nodes, id, new LinkedHashMap());
        localAttrs.putAll(this.defaultNodeAttrs);
        localAttrs.putAll(attrs);
    }

    private final String node_id() throws ParseException {
        String id = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                this.port();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        return id;
    }

    private final void port() throws ParseException {
        this.jj_consume_token(15);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 25: 
            case 44: {
                this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        this.compass_pt();
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.compass_pt();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final List<String> subgraph() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: 
                    case 25: 
                    case 44: {
                        this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        List<String> nodes = this.stmt_list();
        this.jj_consume_token(14);
        return nodes;
    }

    private final void compass_pt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: {
                Token t = this.jj_consume_token(20);
                return t.toString();
            }
            case 44: {
                this.jj_consume_token(44);
                return "";
            }
            case 25: {
                Token t = this.jj_consume_token(25);
                return StringUtil.unescapeQuotes((String)t.toString());
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{512, 160, 0x2100000, 34612672, 65536, 786432, 524288, 34612672, 448, 0x2100000, 2048, 196608, 196608, 0x2100000, 2048, 2048, 34612224, 524288, 2048, 32768, 32768, 0x2100000, 0x2100000, 1024, 0, 0x2100000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 4096, 4096, 0, 0, 0, 4096, 0, 4096, 0, 0, 0, 4096, 0, 0, 4096, 0, 0, 0, 0, 8188, 4096, 0, 4092, 4096};
    }

    public InternalDOTParser(InputStream stream) {
        this(stream, null);
    }

    public InternalDOTParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new InternalDOTParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalDOTParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new InternalDOTParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new InternalDOTParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalDOTParser(InternalDOTParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InternalDOTParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[45];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 26; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 45; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        InternalDOTParser.jj_la1_init_0();
        InternalDOTParser.jj_la1_init_1();
    }

    private static class EdgePair {
        String src;
        String tgt;

        EdgePair(String src, String tgt) {
            this.src = src;
            this.tgt = tgt;
        }

        public String toString() {
            return this.src + " -> " + this.tgt;
        }
    }
}

