/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelDeserializer;
import net.automatalib.serialization.dot.DOTInputModelData;
import net.automatalib.ts.simple.SimpleTS;

public interface DOTInputModelDeserializer<S, I, M extends SimpleTS<S, I>>
extends InputModelDeserializer<I, M> {
    public DOTInputModelData<S, I, M> readModel(InputStream var1) throws IOException;

    default public DOTInputModelData<S, I, M> readModel(URL url) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream((InputStream)url.openStream());){
            DOTInputModelData<S, I, M> dOTInputModelData = this.readModel(is);
            return dOTInputModelData;
        }
    }

    default public DOTInputModelData<S, I, M> readModel(File f) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream((File)f);){
            DOTInputModelData<S, I, M> dOTInputModelData = this.readModel(is);
            return dOTInputModelData;
        }
    }

    default public DOTInputModelData<S, I, M> readModel(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            DOTInputModelData<S, I, M> dOTInputModelData = this.readModel(is);
            return dOTInputModelData;
        }
    }
}

