/* InternalDOTParser.java */
/* Generated By:JavaCC: Do not edit this line. InternalDOTParser.java */
package net.automatalib.serialization.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Preconditions;
import net.automatalib.common.util.string.StringUtil;
import net.automatalib.serialization.FormatException;

/**
 * The parser is based on the official <a href="http://www.graphviz.org/doc/info/lang.html">language definition<a>.
 */
class InternalDOTParser implements InternalDOTParserConstants {

        private Map<String, String> defaultNodeAttrs = new LinkedHashMap<String, String>();
        private Map<String, String> defaultEdgeAttrs = new LinkedHashMap<String, String>();

        private Map<String, Map<String, String>> nodes = new LinkedHashMap<String, Map<String, String>>();
        private Map<EdgePair, Map<String, String>> edges = new LinkedHashMap<EdgePair, Map<String, String>>();

        private boolean parsed;

        private boolean strict;
        private boolean directed;

        private List<Node> transformedNodes;
        private List<Edge> transformedEdges;

        public List<Node> getNodes() {
                Preconditions.checkArgument(this.parsed, "parse() needs to be called first");
                return this.transformedNodes;
        }

        public List<Edge> getEdges() {
                Preconditions.checkArgument(this.parsed, "parse() needs to be called first");
                return this.transformedEdges;
        }

        public boolean isStrict() {
                Preconditions.checkArgument(this.parsed, "parse() needs to be called first");
                return this.strict;
        }

        public boolean isDirected() {
                Preconditions.checkArgument(this.parsed, "parse() needs to be called first");
                return this.directed;
        }

        public void parse() throws FormatException {
                try {
                        graph();
                } catch (ParseException e) {
                        throw new FormatException(e);
                }

                this.parsed = true;

                final List<Node> transformedNodes = new ArrayList<Node>(this.nodes.size());
                final List<Edge> transformedEdges = new ArrayList<Edge>(this.edges.size());

                for (Map.Entry<String, Map<String, String>> entry : nodes.entrySet()) {
                        transformedNodes.add(new Node(entry.getKey(), Collections.unmodifiableMap(entry.getValue())));
                }
                for (Map.Entry<EdgePair, Map<String, String>>  entry : edges.entrySet()) {
                        transformedEdges.add(new Edge(entry.getKey().src, entry.getKey().tgt, Collections.unmodifiableMap(entry.getValue())));
                }

                this.transformedNodes = Collections.unmodifiableList(transformedNodes);
                this.transformedEdges = Collections.unmodifiableList(transformedEdges);

                // allow garbage collection
                this.nodes = null;
                this.edges = null;
        }

        private void addEdges(List<EdgePair> edges, Map<String, String> attrs) {
                Map<String, String> localAttrs = new LinkedHashMap<String, String>(this.defaultEdgeAttrs);
                localAttrs.putAll(attrs);

                for (EdgePair ep : edges) {
                        String src = ep.src;
                        String tgt = ep.tgt;

                        this.edges.put(ep, localAttrs);

                        // if edges define new states, add them to the node map
                        this.putIfAbsent(this.nodes, src, new LinkedHashMap<String, String>(this.defaultNodeAttrs));
                        this.putIfAbsent(this.nodes, tgt, new LinkedHashMap<String, String>(this.defaultNodeAttrs));
                }
        }

        /*
	* Utility method, since JavaCC parser does not allow Java 8 lambda statements
	*/
        private <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
                if (!map.containsKey(key)) {
                        map.put(key, value);
                        return value;
                } else {
                        return map.get(key);
                }
        }

        /*
	* We require identity semantics
	*/
        private static class EdgePair {
                String src;
                String tgt;

                EdgePair(String src, String tgt) {
                        this.src = src;
                        this.tgt = tgt;
                }

                @Override
                public String toString() {
                  return src + " -> " + tgt;
                }
        }

  final private void graph() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRICT:{
      jj_consume_token(STRICT);
this.strict = true;
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GRAPH:{
      jj_consume_token(GRAPH);
      break;
      }
    case DIGRAPH:{
      jj_consume_token(DIGRAPH);
this.directed = true;
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:
    case QID:
    case 44:{
      identifier();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    jj_consume_token(LCURLY);
    stmt_list();
    jj_consume_token(RCURLY);
}

  final private List<String> stmt_list() throws ParseException {List<String> nodes;
        List<String> allNodes = new ArrayList<String>();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDGE:
      case GRAPH:
      case NODE:
      case SUBGRAPH:
      case LCURLY:
      case ID:
      case QID:
      case 44:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_1;
      }
      nodes = stmt();
allNodes.addAll(nodes);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        ;
      }
    }
{if ("" != null) return allNodes;}
    throw new Error("Missing return statement in function");
}

  final private List<String> stmt() throws ParseException {String id;
        List<String> nodes = new ArrayList<String>();
        List<String> graphSrc, graphTgt, edgeTgt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:
    case QID:
    case 44:{
      id = identifier();
nodes.add(id);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDGEOP:{
        edgeTgt = edge_stmt(id);
nodes.addAll(edgeTgt);
        break;
        }
      case EQUALS:{
        jj_consume_token(EQUALS);
        identifier();
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        node_stmt(id);
      }
      break;
      }
    case SUBGRAPH:
    case LCURLY:{
      graphSrc = subgraph();
nodes.addAll(graphSrc);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDGEOP:{
        graphTgt = edge_stmt_sgr(graphSrc);
nodes.addAll(graphTgt);
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      break;
      }
    case EDGE:
    case GRAPH:
    case NODE:{
      attr_stmt();
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return nodes;}
    throw new Error("Missing return statement in function");
}

  final private void attr_stmt() throws ParseException {Map<String, String> defaults = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GRAPH:{
      jj_consume_token(GRAPH);
      break;
      }
    case NODE:{
      jj_consume_token(NODE);
defaults = this.defaultNodeAttrs;
      break;
      }
    case EDGE:{
      jj_consume_token(EDGE);
defaults = this.defaultEdgeAttrs;
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    attr_list(defaults);
}

  final private void attr_list(Map<String, String> attrs) throws ParseException {
    label_2:
    while (true) {
      jj_consume_token(LBRACK);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:
      case QID:
      case 44:{
        a_list(attrs);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      jj_consume_token(RBRACK);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACK:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_2;
      }
    }
}

  final private void a_list(Map<String, String> attrs) throws ParseException {String key;
        String value;
    label_3:
    while (true) {
      key = identifier();
      jj_consume_token(EQUALS);
      value = identifier();
if (attrs != null) attrs.put(key, value);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:
      case COMMA:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          jj_consume_token(SEMICOLON);
          break;
          }
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:
      case QID:
      case 44:{
        ;
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_3;
      }
    }
}

  final private List<String> edge_stmt(String src) throws ParseException {List<EdgePair> edges = new ArrayList<EdgePair>();
        List<String> tgts;
        Map<String, String> attrs = new LinkedHashMap<String, String>();
    tgts = edgeRHS(Collections.singletonList(src), edges);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACK:{
      attr_list(attrs);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
addEdges(edges, attrs);
                {if ("" != null) return tgts;}
    throw new Error("Missing return statement in function");
}

  final private List<String> edge_stmt_sgr(List<String> srcs) throws ParseException {List<EdgePair> edges = new ArrayList<EdgePair>();
        List<String> tgts;
        Map<String, String> attrs = new LinkedHashMap<String, String>();
    tgts = edgeRHS(srcs, edges);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACK:{
      attr_list(attrs);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
addEdges(edges, attrs);
                {if ("" != null) return tgts;}
    throw new Error("Missing return statement in function");
}

  final private List<String> edgeRHS(List<String> srcs, List<EdgePair> edges) throws ParseException {String tgt;
        List<String> tgts;
        List<String> nodes = new ArrayList<String>();
    label_4:
    while (true) {
      jj_consume_token(EDGEOP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:
      case QID:
      case 44:{
        tgt = node_id();
tgts = Collections.singletonList(tgt);
        break;
        }
      case SUBGRAPH:
      case LCURLY:{
        tgts = subgraph();
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
for (String s : srcs) {
                                for (String t : tgts) {
                                        edges.add(new EdgePair(s, t));
                                }
                        }
                        nodes.addAll(tgts);
                        srcs = tgts;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDGEOP:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_4;
      }
    }
{if ("" != null) return nodes;}
    throw new Error("Missing return statement in function");
}

  final private void node_stmt(String id) throws ParseException {Map<String, String> attrs = new LinkedHashMap<String, String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACK:{
      attr_list(attrs);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
// If node was already defined, merge attributes
                Map<String, String> localAttrs = this.putIfAbsent(this.nodes, id, new LinkedHashMap<String, String>());
                localAttrs.putAll(this.defaultNodeAttrs);
                localAttrs.putAll(attrs);
}

  final private String node_id() throws ParseException {String id;
    id = identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      port();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
{if ("" != null) return id;}
    throw new Error("Missing return statement in function");
}

  final private void port() throws ParseException {
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:
    case QID:
    case 44:{
      identifier();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        compass_pt();
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      break;
      }
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:{
      compass_pt();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final private List<String> subgraph() throws ParseException {List<String> nodes;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBGRAPH:{
      jj_consume_token(SUBGRAPH);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:
      case QID:
      case 44:{
        identifier();
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(LCURLY);
    nodes = stmt_list();
    jj_consume_token(RCURLY);
{if ("" != null) return nodes;}
    throw new Error("Missing return statement in function");
}

  final private void compass_pt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 34:{
      jj_consume_token(34);
      break;
      }
    case 35:{
      jj_consume_token(35);
      break;
      }
    case 36:{
      jj_consume_token(36);
      break;
      }
    case 37:{
      jj_consume_token(37);
      break;
      }
    case 38:{
      jj_consume_token(38);
      break;
      }
    case 39:{
      jj_consume_token(39);
      break;
      }
    case 40:{
      jj_consume_token(40);
      break;
      }
    case 41:{
      jj_consume_token(41);
      break;
      }
    case 42:{
      jj_consume_token(42);
      break;
      }
    case 43:{
      jj_consume_token(43);
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final private String identifier() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:{
      t = jj_consume_token(ID);
{if ("" != null) return t.toString();}
      break;
      }
    case 44:{
      jj_consume_token(44);
{if ("" != null) return "";}
      break;
      }
    case QID:{
      t = jj_consume_token(QID);
{if ("" != null) return StringUtil.unescapeQuotes(t.toString());}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  /** Generated Token Manager. */
  public InternalDOTParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[26];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x200,0xa0,0x2100000,0x21025c0,0x10000,0xc0000,0x80000,0x21025c0,0x1c0,0x2100000,0x800,0x30000,0x30000,0x2100000,0x800,0x800,0x2102400,0x80000,0x800,0x8000,0x8000,0x2100000,0x2100000,0x400,0x0,0x2100000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x1000,0x0,0x1000,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x1ffc,0x1000,0x0,0xffc,0x1000,};
	}

  /** Constructor with InputStream. */
  public InternalDOTParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public InternalDOTParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new InternalDOTParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public InternalDOTParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new InternalDOTParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new InternalDOTParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public InternalDOTParser(InternalDOTParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(InternalDOTParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[45];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 26; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 45; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
