/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.aut;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.simple.SimpleAutomaton;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.words.Alphabet;

public final class AUTWriter {
    private AUTWriter() {
    }

    public static <S, I> void writeAutomaton(SimpleAutomaton<S, I> automaton, Alphabet<I> alphabet, OutputStream os) throws IOException {
        AUTWriter.writeAutomaton(automaton, alphabet, str -> "\"" + str + "\"", os);
    }

    public static <S, I> void writeAutomaton(SimpleAutomaton<S, I> automaton, Alphabet<I> alphabet, Function<I, String> inputTransformer, OutputStream os) throws IOException {
        HashSet<TransitionTriple<S, I>> transitions = new HashSet<TransitionTriple<S, I>>();
        for (Object s : automaton.getStates()) {
            for (Object i : alphabet) {
                Set succs = automaton.getSuccessors(s, i);
                if (succs == null || succs.isEmpty()) continue;
                for (Object succ : succs) {
                    transitions.add(new TransitionTriple(s, i, succ));
                }
            }
        }
        try (Writer w = IOUtil.asBufferedUTF8Writer((OutputStream)os);){
            AUTWriter.writeHeader(automaton, transitions, w);
            AUTWriter.writeTransitions(automaton, transitions, inputTransformer, w);
        }
    }

    private static <S, I> void writeHeader(SimpleAutomaton<S, I> automaton, Set<TransitionTriple<S, I>> transitions, Appendable appendable) throws IOException {
        Set inits = automaton.getInitialStates();
        if (inits == null || inits.size() != 1) {
            throw new IllegalArgumentException("Automaton needs to exactly specify a single initial state");
        }
        Object init = inits.iterator().next();
        StateIDs stateIds = automaton.stateIDs();
        appendable.append("des (");
        appendable.append(Integer.toString(stateIds.getStateId(init)));
        appendable.append(", ");
        appendable.append(Integer.toString(transitions.size()));
        appendable.append(", ");
        appendable.append(Integer.toString(automaton.size()));
        appendable.append(')');
        appendable.append(System.lineSeparator());
    }

    private static <S, I> void writeTransitions(SimpleAutomaton<S, I> automaton, Set<TransitionTriple<S, I>> transitions, Function<I, String> inputTransformer, Appendable appendable) throws IOException {
        StateIDs stateIds = automaton.stateIDs();
        for (TransitionTriple<S, I> trans : transitions) {
            appendable.append('(');
            appendable.append(Integer.toString(stateIds.getStateId(trans.src)));
            appendable.append(", ");
            appendable.append(inputTransformer.apply(trans.input));
            appendable.append(", ");
            appendable.append(Integer.toString(stateIds.getStateId(trans.dest)));
            appendable.append(')');
            appendable.append(System.lineSeparator());
        }
    }

    private static class TransitionTriple<S, I> {
        final S src;
        final I input;
        final S dest;

        TransitionTriple(S src, I input, S dest) {
            this.src = src;
            this.input = input;
            this.dest = dest;
        }
    }
}

