/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.aut;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.impl.Alphabets;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.common.util.HashUtil;
import net.automatalib.common.util.IOUtil;
import net.automatalib.exception.FormatException;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelDeserializer;
import net.automatalib.ts.simple.SimpleTS;

class InternalAUTParser<I, T, A extends MutableAutomaton<Integer, I, T, ?, ?>>
implements InputModelDeserializer<I, A> {
    private final Function<String, I> inputTransformer;
    private final AutomatonCreator<A, I> creator;
    private final Set<String> alphabetSymbols;
    private final Map<Integer, Map<String, Set<Integer>>> transitionMap;
    private int initialState;
    private int numStates;
    private char[] currentLineContent;
    private int currentLine;
    private int currentPos;

    InternalAUTParser(Function<String, I> inputTransformer, AutomatonCreator<A, I> creator) {
        this.inputTransformer = inputTransformer;
        this.creator = creator;
        this.alphabetSymbols = new HashSet<String>();
        this.transitionMap = new HashMap<Integer, Map<String, Set<Integer>>>();
    }

    public InputModelData<I, A> readModel(InputStream is) throws IOException, FormatException {
        try {
            InputModelData inputModelData;
            try (BufferedReader br = new BufferedReader(IOUtil.asNonClosingUTF8Reader((InputStream)is));){
                this.parseHeader(br);
                while (this.parseTransition(br)) {
                }
                HashMap<String, I> inputMap = new HashMap<String, I>(HashUtil.capacity((int)this.alphabetSymbols.size()));
                for (String s : this.alphabetSymbols) {
                    inputMap.put(s, this.inputTransformer.apply(s));
                }
                Alphabet alphabet = Alphabets.fromCollection(inputMap.values());
                MutableAutomaton result = (MutableAutomaton)this.creator.createAutomaton(alphabet, this.numStates);
                for (int i = 0; i < this.numStates; ++i) {
                    result.addState();
                }
                for (Map.Entry<Integer, Map<String, Set<Integer>>> outgoing : this.transitionMap.entrySet()) {
                    Integer src = outgoing.getKey();
                    for (Map.Entry<String, Set<Integer>> targets : outgoing.getValue().entrySet()) {
                        String input = targets.getKey();
                        Set<Integer> tgts = targets.getValue();
                        for (Integer tgt : tgts) {
                            result.addTransition((Object)src, inputMap.get(input), (Object)tgt, null);
                        }
                    }
                }
                result.setInitial((Object)this.initialState, true);
                inputModelData = new InputModelData((SimpleTS)result, alphabet);
            }
            return inputModelData;
        }
        finally {
            this.initialState = 0;
            this.numStates = 0;
            this.currentLineContent = null;
            this.currentLine = 0;
            this.currentPos = 0;
            this.alphabetSymbols.clear();
            this.transitionMap.clear();
        }
    }

    private void parseHeader(BufferedReader reader) throws IOException, FormatException {
        String line = reader.readLine();
        if (line == null) {
            throw new FormatException(this.buildErrorMessage("Missing description"));
        }
        this.currentLineContent = line.toCharArray();
        this.currentPos = 0;
        this.shiftToNextNonWhitespace();
        this.verifyDesAndShift();
        this.verifyLBracketAndShift();
        this.initialState = this.parseNumberAndShift();
        this.verifyCommaAndShift();
        this.parseNumberAndShift();
        this.verifyCommaAndShift();
        this.numStates = this.parseNumberAndShift();
        if (this.numStates < 1) {
            throw new FormatException("Number of states must be >= 1");
        }
        this.verifyRBracketAndShift();
    }

    private boolean parseTransition(BufferedReader reader) throws IOException, FormatException {
        String line = reader.readLine();
        if (line == null) {
            return false;
        }
        this.currentLineContent = line.toCharArray();
        ++this.currentLine;
        this.currentPos = 0;
        this.shiftToNextNonWhitespace();
        this.verifyLBracketAndShift();
        int start = this.parseNumberAndShift();
        this.verifyCommaAndShift();
        String label = this.parseLabelAndShift();
        this.verifyCommaAndShift();
        int dest = this.parseNumberAndShift();
        this.verifyRBracketAndShift();
        this.alphabetSymbols.add(label);
        this.transitionMap.computeIfAbsent(start, k -> new HashMap()).computeIfAbsent(label, k -> new HashSet()).add(dest);
        return true;
    }

    private void verifyDesAndShift() throws FormatException {
        if (this.currentLineContent[this.currentPos] != 'd' || this.currentLineContent[this.currentPos + 1] != 'e' || this.currentLineContent[this.currentPos + 2] != 's') {
            throw new FormatException(this.buildErrorMessage("Missing 'des' keyword"));
        }
        this.currentPos += 3;
        this.shiftToNextNonWhitespace();
    }

    private void verifyLBracketAndShift() throws FormatException {
        this.verifySymbolAndShift('(');
    }

    private void verifyRBracketAndShift() throws FormatException {
        this.verifySymbolAndShift(')');
    }

    private void verifyCommaAndShift() throws FormatException {
        this.verifySymbolAndShift(',');
    }

    private void verifySymbolAndShift(char symbol) throws FormatException {
        if (this.currentLineContent[this.currentPos] != symbol) {
            throw new FormatException(this.buildErrorMessage("Expected: " + symbol));
        }
        ++this.currentPos;
        this.shiftToNextNonWhitespace();
    }

    private void shiftToNextNonWhitespace() {
        while (this.currentPos < this.currentLineContent.length && Character.isWhitespace(this.currentLineContent[this.currentPos])) {
            ++this.currentPos;
        }
    }

    private int parseNumberAndShift() throws FormatException {
        StringBuilder sb = new StringBuilder();
        char sym = this.currentLineContent[this.currentPos];
        while (Character.isDigit(sym)) {
            sb.append(sym);
            ++this.currentPos;
            sym = this.currentLineContent[this.currentPos];
        }
        if (sb.length() == 0) {
            throw new FormatException(this.buildErrorMessage("Expected a positive number"));
        }
        this.shiftToNextNonWhitespace();
        return Integer.parseInt(sb.toString());
    }

    private String parseLabelAndShift() throws FormatException {
        if (this.currentLineContent[this.currentPos] == '\"') {
            return this.parseQuotedLabelAndShift();
        }
        return this.parseNormalLabelAndShift();
    }

    private String parseQuotedLabelAndShift() {
        int openingIndex = this.currentPos;
        int closingIndex = this.currentLineContent.length - 1;
        while (this.currentLineContent[closingIndex--] != '\"') {
        }
        this.currentPos = closingIndex + 2;
        this.shiftToNextNonWhitespace();
        return new String(this.currentLineContent, openingIndex + 1, closingIndex - openingIndex);
    }

    private String parseNormalLabelAndShift() throws FormatException {
        char firstChar = this.currentLineContent[this.currentPos];
        if (this.currentLineContent[this.currentPos] == '*') {
            ++this.currentPos;
            this.shiftToNextNonWhitespace();
            return "*";
        }
        if (Character.isLetter(firstChar)) {
            int startIdx = this.currentPos;
            while (this.isValidIdentifier()) {
                ++this.currentPos;
            }
            int endIdx = this.currentPos;
            this.shiftToNextNonWhitespace();
            return new String(this.currentLineContent, startIdx, endIdx - startIdx);
        }
        throw new FormatException(this.buildErrorMessage("Invalid unquoted label"));
    }

    private boolean isValidIdentifier() {
        char currentChar = this.currentLineContent[this.currentPos];
        return Character.isLetterOrDigit(currentChar) || currentChar == '_';
    }

    private String buildErrorMessage(String desc) {
        return "In line " + this.currentLine + ", col " + this.currentPos + ": " + desc;
    }
}

