/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.aut;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.automata.simple.SimpleAutomaton;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.ts.simple.SimpleTS;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

class InternalAUTParser {
    private int initialState;
    private final Set<String> alphabetSymbols = new HashSet<String>();
    private final Map<Integer, Map<String, Integer>> transitionMap = new HashMap<Integer, Map<String, Integer>>();
    private final InputStream inputStream;
    private char[] currentLineContent;
    private int currentLine;
    private int currentPos;

    InternalAUTParser(InputStream is) {
        this.inputStream = is;
    }

    public <I> InputModelData<I, SimpleAutomaton<Integer, I>> parse(Function<String, I> inputTransformer) throws IOException {
        try (BufferedReader br = new BufferedReader(IOUtil.asUncompressedBufferedNonClosingUTF8Reader((InputStream)this.inputStream));){
            this.parseHeader(br);
            while (this.parseTransition(br)) {
            }
            Map inputMap = this.alphabetSymbols.stream().collect(Collectors.toMap(Function.identity(), inputTransformer));
            Alphabet alphabet = Alphabets.fromCollection(inputMap.values());
            CompactNFA result = new CompactNFA(alphabet, this.transitionMap.size());
            for (int i = 0; i < this.transitionMap.size(); ++i) {
                result.addState();
            }
            for (Map.Entry<Integer, Map<String, Integer>> outgoing : this.transitionMap.entrySet()) {
                Integer src = outgoing.getKey();
                for (Map.Entry<String, Integer> targets : outgoing.getValue().entrySet()) {
                    String input = targets.getKey();
                    Integer dest = targets.getValue();
                    result.addTransition(src, inputMap.get(input), dest);
                }
            }
            result.setInitial(this.initialState, true);
            InputModelData inputModelData = new InputModelData((SimpleTS)result, alphabet);
            return inputModelData;
        }
    }

    private void parseHeader(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new IllegalArgumentException(this.buildErrorMessage("Missing description"));
        }
        this.currentLineContent = line.toCharArray();
        this.currentPos = 0;
        this.shiftToNextNonWhitespace();
        this.verifyDesAndShift();
        this.verifyLBracketAndShift();
        this.initialState = this.parseNumberAndShift();
        this.verifyCommaAndShift();
        this.parseNumberAndShift();
        this.verifyCommaAndShift();
        this.parseNumberAndShift();
        this.verifyRBracketAndShift();
    }

    private boolean parseTransition(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return false;
        }
        this.currentLineContent = line.toCharArray();
        ++this.currentLine;
        this.currentPos = 0;
        this.shiftToNextNonWhitespace();
        this.verifyLBracketAndShift();
        int start = this.parseNumberAndShift();
        this.verifyCommaAndShift();
        String label = this.parseLabelAndShift();
        this.verifyCommaAndShift();
        int dest = this.parseNumberAndShift();
        this.verifyRBracketAndShift();
        this.alphabetSymbols.add(label);
        this.transitionMap.computeIfAbsent(start, k -> new HashMap()).put(label, dest);
        return true;
    }

    private void verifyDesAndShift() {
        if (this.currentLineContent[this.currentPos] != 'd' || this.currentLineContent[this.currentPos + 1] != 'e' || this.currentLineContent[this.currentPos + 2] != 's') {
            throw new IllegalArgumentException(this.buildErrorMessage("Missing 'des' keyword"));
        }
        this.currentPos += 3;
        this.shiftToNextNonWhitespace();
    }

    private void verifyLBracketAndShift() {
        this.verifySymbolAndShift('(');
    }

    private void verifyRBracketAndShift() {
        this.verifySymbolAndShift(')');
    }

    private void verifyCommaAndShift() {
        this.verifySymbolAndShift(',');
    }

    private void verifySymbolAndShift(char symbol) {
        if (this.currentLineContent[this.currentPos] != symbol) {
            throw new IllegalArgumentException(this.buildErrorMessage("Expected: " + symbol));
        }
        ++this.currentPos;
        this.shiftToNextNonWhitespace();
    }

    private void shiftToNextNonWhitespace() {
        block3: for (int i = this.currentPos; i < this.currentLineContent.length; ++i) {
            switch (this.currentLineContent[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.currentPos = i;
                    return;
                }
            }
        }
    }

    private int parseNumberAndShift() {
        StringBuilder sb = new StringBuilder();
        char sym = this.currentLineContent[this.currentPos];
        while (Character.isDigit(sym)) {
            sb.append(sym);
            ++this.currentPos;
            sym = this.currentLineContent[this.currentPos];
        }
        this.shiftToNextNonWhitespace();
        return Integer.parseInt(sb.toString());
    }

    private String parseLabelAndShift() {
        if (this.currentLineContent[this.currentPos] == '\"') {
            return this.parseQuotedLabelAndShift();
        }
        return this.parseNormalLabelAndShift();
    }

    private String parseQuotedLabelAndShift() {
        int openingIndex = this.currentPos;
        int closingIndex = this.currentLineContent.length - 1;
        while (this.currentLineContent[closingIndex--] != '\"') {
        }
        this.currentPos = closingIndex + 2;
        this.shiftToNextNonWhitespace();
        return new String(this.currentLineContent, openingIndex + 1, closingIndex - openingIndex);
    }

    private String parseNormalLabelAndShift() {
        char firstChar = this.currentLineContent[this.currentPos];
        if (this.currentLineContent[this.currentPos] == '*') {
            ++this.currentPos;
            this.shiftToNextNonWhitespace();
            return "*";
        }
        if (Character.isLetter(firstChar)) {
            int startIdx = this.currentPos;
            while (this.isValidIdentifier()) {
                ++this.currentPos;
            }
            int endIdx = this.currentPos;
            this.shiftToNextNonWhitespace();
            return new String(this.currentLineContent, startIdx, endIdx - startIdx);
        }
        throw new IllegalArgumentException(this.buildErrorMessage("Invalid unquoted label"));
    }

    private boolean isValidIdentifier() {
        char currentChar = this.currentLineContent[this.currentPos];
        return Character.isLetterOrDigit(currentChar) || currentChar == '_';
    }

    private String buildErrorMessage(String desc) {
        return "In line " + this.currentLine + ", col " + this.currentPos + ": " + desc;
    }
}

