/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminDFA;
import net.automatalib.modelcheckers.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.serialization.fsm.parser.FSM2DFAParser;
import net.automatalib.serialization.fsm.parser.FSMParseException;

public class LTSminMonitorDFA<I>
extends AbstractLTSminMonitor<I, DFA<?, I>, DFA<?, I>>
implements LTSminDFA<I, DFA<?, I>> {
    public LTSminMonitorDFA(boolean keepFiles, Function<String, I> string2Input) {
        super(keepFiles, string2Input);
    }

    @Nullable
    public DFA<?, I> findCounterExample(DFA<?, I> automaton, Collection<? extends I> inputs, String property) throws ModelCheckingException {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        try {
            CompactDFA result;
            if (fsm != null) {
                result = (CompactDFA)FSM2DFAParser.getParser(inputs, this.getString2Input(), (String)"label", (String)"accept").readModel(fsm);
                if (!this.isKeepFiles() && !fsm.delete()) {
                    throw new ModelCheckingException("Could not delete file: " + fsm.getAbsolutePath());
                }
                for (Integer state : result.getStates()) {
                    boolean deadlocks = result.getInputAlphabet().stream().noneMatch(i -> result.getSuccessor((Object)state, i) != null);
                    result.setAccepting(state, deadlocks);
                }
            } else {
                result = null;
            }
            return result;
        }
        catch (IOException | FSMParseException e) {
            throw new ModelCheckingException((Exception)e);
        }
    }
}

