/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.automata.transducers.impl.compact.CompactMealyTransition;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminMealy;
import net.automatalib.modelcheckers.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.serialization.fsm.parser.FSMParseException;
import net.automatalib.words.Word;

public abstract class AbstractLTSminMonitorMealy<I, O>
extends AbstractLTSminMonitor<I, MealyMachine<?, I, ?, O>, MealyMachine<?, I, ?, O>>
implements LTSminMealy<I, O, MealyMachine<?, I, ?, O>> {
    private final Function<String, O> string2Output;
    private Collection<? super O> skipOutputs;

    protected AbstractLTSminMonitorMealy(boolean keepFiles, Function<String, I> string2Input, Function<String, O> string2Output, Collection<? super O> skipOutputs) {
        super(keepFiles, string2Input);
        this.string2Output = string2Output;
        this.skipOutputs = skipOutputs == null ? Collections.emptyList() : skipOutputs;
    }

    @Override
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    @Nullable
    public MealyMachine<?, I, ?, O> findCounterExample(MealyMachine<?, I, ?, O> automaton, Collection<? extends I> inputs, String property) throws ModelCheckingException {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        try {
            CompactMealy result;
            CompactMealy compactMealy = result = fsm != null ? this.fsm2Mealy(fsm, automaton, inputs) : null;
            if (!this.isKeepFiles() && fsm != null && !fsm.delete()) {
                throw new ModelCheckingException("Could not delete file: " + fsm.getAbsolutePath());
            }
            return result == null ? null : new MealyMachine<Integer, I, CompactMealyTransition<O>, O>(){
                private final Integer deadlock;
                {
                    this.deadlock = result.getStates().stream().filter(s -> result.getInputAlphabet().stream().allMatch(i -> result.getSuccessor(s, i) == null)).findFirst().orElseThrow(() -> new ModelCheckingException("No deadlock found"));
                }

                public Word<O> computeOutput(Iterable<? extends I> input) {
                    Integer state = (Integer)this.getState(input);
                    return state != null && state.equals(this.deadlock) ? (Word)super.computeOutput(input) : null;
                }

                @Nullable
                public Integer getInitialState() {
                    return result.getInitialState();
                }

                @Nonnull
                public Integer getSuccessor(CompactMealyTransition<O> transition) {
                    return result.getSuccessor(transition);
                }

                @Nullable
                public CompactMealyTransition<O> getTransition(Integer state, @Nullable I input) {
                    return (CompactMealyTransition)result.getTransition(state, input);
                }

                @Nullable
                public O getTransitionOutput(CompactMealyTransition<O> transition) {
                    return result.getTransitionOutput(transition);
                }

                @Nonnull
                public Collection<Integer> getStates() {
                    return result.getStates();
                }
            };
        }
        catch (IOException | FSMParseException e) {
            throw new ModelCheckingException((Exception)e);
        }
    }
}

