/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.ltl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.automatalib.automata.concepts.DetOutputAutomaton;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminMealy;
import net.automatalib.modelcheckers.ltsmin.ltl.AbstractLTSminLTL;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;
import net.automatalib.modelchecking.lasso.MealyLassoImpl;
import net.automatalib.serialization.fsm.parser.FSMParseException;

public abstract class AbstractLTSminLTLMealy<I, O>
extends AbstractLTSminLTL<I, MealyMachine<?, I, ?, O>, Lasso.MealyLasso<I, O>>
implements ModelCheckerLasso.MealyModelCheckerLasso<I, O, String>,
LTSminMealy<I, O, Lasso.MealyLasso<I, O>> {
    private final Function<String, O> string2Output;
    private Collection<? super O> skipOutputs;

    protected AbstractLTSminLTLMealy(boolean keepFiles, Function<String, I> string2Input, Function<String, O> string2Output, int minimumUnfolds, double multiplier, Collection<? super O> skipOutputs) {
        super(keepFiles, string2Input, minimumUnfolds, multiplier);
        this.string2Output = string2Output;
        this.skipOutputs = skipOutputs == null ? Collections.emptyList() : skipOutputs;
    }

    @Override
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    @Nullable
    public Lasso.MealyLasso<I, O> findCounterExample(MealyMachine<?, I, ?, O> automaton, Collection<? extends I> inputs, String property) throws ModelCheckingException {
        MealyLassoImpl result;
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm != null) {
            CompactMealy mealy;
            try {
                mealy = this.fsm2Mealy(fsm, automaton, inputs);
                if (!this.isKeepFiles() && !fsm.delete()) {
                    throw new ModelCheckingException("Could not delete file: " + fsm.getAbsolutePath());
                }
            }
            catch (IOException | FSMParseException e) {
                throw new ModelCheckingException((Exception)e);
            }
            result = new MealyLassoImpl((DetOutputAutomaton)mealy, (Collection)mealy.getInputAlphabet(), this.computeUnfolds(automaton.size()));
        } else {
            result = null;
        }
        return result;
    }
}

