/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.ltl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.AbstractLTSmin;
import net.automatalib.modelcheckers.ltsmin.LTSminVersion;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;
import net.automatalib.modelchecking.modelchecker.AbstractUnfoldingModelChecker;

public abstract class AbstractLTSminLTL<I, A, L extends Lasso<I, ?>>
extends AbstractLTSmin<I, A, L>
implements ModelCheckerLasso<I, A, String, L> {
    public static final LTSminVersion REQUIRED_VERSION = LTSminVersion.of(3, 0, 0);
    private final AbstractUnfoldingModelChecker<I, A, String, L> unfolder;

    protected AbstractLTSminLTL(boolean keepFiles, Function<String, I> string2Input, int minimumUnfolds, double multiplier) throws ModelCheckingException {
        super(keepFiles, string2Input);
        this.unfolder = new AbstractUnfoldingModelChecker<I, A, String, L>(minimumUnfolds, multiplier){

            @Nullable
            public L findCounterExample(A automaton, Collection<? extends I> inputs, String property) throws ModelCheckingException {
                return null;
            }
        };
    }

    @Override
    protected LTSminVersion getMinimumRequiredVersion() {
        return REQUIRED_VERSION;
    }

    @Override
    protected List<String> getExtraCommandLineOptions() {
        return Lists.newArrayList((Object[])new String[]{"--buchi-type=spotba", "--strategy=ufscc"});
    }

    public double getMultiplier() {
        return this.unfolder.getMultiplier();
    }

    public void setMultiplier(double multiplier) throws IllegalArgumentException {
        this.unfolder.setMultiplier(multiplier);
    }

    public int getMinimumUnfolds() {
        return this.unfolder.getMinimumUnfolds();
    }

    public void setMinimumUnfolds(int minimumUnfolds) throws IllegalArgumentException {
        this.unfolder.setMinimumUnfolds(minimumUnfolds);
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean keepFiles() {
            return false;
        }

        public static int minimumUnfolds() {
            return 3;
        }

        public static double multiplier() {
            return 1.0;
        }
    }
}

