/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LTSminVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminVersion.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v([0-9]+)\\.([0-9]+)\\.([0-9]+)");
    private final int major;
    private final int minor;
    private final int patch;

    private LTSminVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static LTSminVersion of(int major, int minor, int patch) {
        return new LTSminVersion(major, minor, patch);
    }

    public static LTSminVersion parse(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            LTSminVersion result = LTSminVersion.of(major, minor, patch);
            LOGGER.debug("Found version '{}'", (Object)version);
            LOGGER.debug("Parsed as '{}'", (Object)result);
            return result;
        }
        LTSminVersion fallback = LTSminVersion.of(0, 0, 0);
        LOGGER.warn("Couldn't parse LTSmin version '{}'", (Object)version);
        LOGGER.warn("Falling back to version '{}'", (Object)fallback);
        return fallback;
    }

    public boolean supports(LTSminVersion required) {
        if (this.major > required.major) {
            return true;
        }
        if (this.major == required.major) {
            if (this.minor > required.minor) {
                return true;
            }
            if (this.minor == required.minor) {
                return this.patch >= required.patch;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("v%d.%d.%d", this.major, this.minor, this.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LTSminVersion)) {
            return false;
        }
        LTSminVersion that = (LTSminVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Integer.hashCode(this.major);
        result = 31 * result + Integer.hashCode(this.minor);
        result = 31 * result + Integer.hashCode(this.patch);
        return result;
    }
}

