/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Paths;
import net.automatalib.AutomataLibProperty;
import net.automatalib.AutomataLibSettings;
import net.automatalib.commons.util.process.ProcessUtil;
import net.automatalib.modelcheckers.ltsmin.LTSminVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LTSminUtil {
    public static final String ETF2LTS_MC;
    public static final String LTSMIN_CONVERT;
    private static final Logger LOGGER;
    private static final String CHECK;
    private static final int VERSION_EXIT = 255;
    private static boolean verbose;
    private static LTSminVersion detectedVersion;

    private LTSminUtil() {
        throw new AssertionError();
    }

    public static boolean isInstalled() {
        return detectedVersion != null;
    }

    public static LTSminVersion getVersion() {
        return detectedVersion;
    }

    public static boolean supports(LTSminVersion requiredVersion) {
        return LTSminUtil.isInstalled() && detectedVersion.supports(requiredVersion);
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        LTSminUtil.verbose = verbose;
    }

    public static void detectLTSmin() {
        LTSminVersion etf2ltsVersion = LTSminUtil.detectLTSmin(ETF2LTS_MC);
        LTSminVersion ltsminConvertVersion = LTSminUtil.detectLTSmin(LTSMIN_CONVERT);
        if (etf2ltsVersion != null && ltsminConvertVersion != null) {
            if (!etf2ltsVersion.equals(ltsminConvertVersion)) {
                LOGGER.warn("Found differing etf2lts version '{}' and lstminConver version '{}'. Choosing the former", (Object)etf2ltsVersion, (Object)ltsminConvertVersion);
            }
            detectedVersion = etf2ltsVersion;
        }
    }

    private static LTSminVersion detectLTSmin(String bin) {
        String[] commandLine = new String[]{bin, "--version"};
        StringWriter stringWriter = new StringWriter();
        try {
            int exitValue = ProcessUtil.invokeProcess((String[])commandLine, stringWriter::append);
            if (exitValue != 255) {
                LOGGER.debug(String.format(CHECK, bin, String.format("Command '%s --version' did not exit with 255", bin)));
                return null;
            }
            return LTSminVersion.parse(stringWriter.toString());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error(String.format(CHECK, bin, e.toString()), (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(LTSminUtil.class);
        CHECK = "An exception occurred while checking if LTSmin is installed. Could not run binary '%s', the following exception occurred: %s. LTSmin can be obtained at https://ltsmin.utwente.nl. If you installed LTSmin in a non standard location you can set the property: '" + AutomataLibProperty.LTSMIN_PATH.getPropertyKey() + "'. Setting the $PATH variable works too.";
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String ltsMinPath = settings.getProperty(AutomataLibProperty.LTSMIN_PATH, "");
        ETF2LTS_MC = Paths.get(ltsMinPath, "etf2lts-mc").toString();
        LTSMIN_CONVERT = Paths.get(ltsMinPath, "ltsmin-convert").toString();
        verbose = !settings.getProperty(AutomataLibProperty.LTSMIN_VERBOSE, Boolean.toString(LOGGER.isDebugEnabled())).equalsIgnoreCase("false");
        LTSminUtil.detectLTSmin();
    }
}

