/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.automatalib.commons.util.process.ProcessUtil;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSmin;
import net.automatalib.modelcheckers.ltsmin.LTSminUtil;
import net.automatalib.modelcheckers.ltsmin.LTSminVersion;
import net.automatalib.modelchecking.ModelChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLTSmin<I, A, R>
implements ModelChecker<I, A, String, R>,
LTSmin<I, A, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLTSmin.class);
    private final boolean keepFiles;
    private final Function<String, I> string2Input;

    protected AbstractLTSmin(boolean keepFiles, Function<String, I> string2Input) throws ModelCheckingException {
        this.keepFiles = keepFiles;
        this.string2Input = string2Input;
        if (!LTSminUtil.supports(this.getMinimumRequiredVersion())) {
            throw new ModelCheckingException("LTSmin binary could not be detected in the correct version");
        }
    }

    protected abstract LTSminVersion getMinimumRequiredVersion();

    protected abstract List<String> getExtraCommandLineOptions();

    @Override
    public boolean isKeepFiles() {
        return this.keepFiles;
    }

    @Override
    public Function<String, I> getString2Input() {
        return this.string2Input;
    }

    protected final File findCounterExampleFSM(A hypothesis, Collection<? extends I> inputs, String formula) throws ModelCheckingException {
        File fsm;
        File gcf;
        File etf;
        try {
            etf = File.createTempFile("automaton2etf", ".etf");
            gcf = File.createTempFile("etf2gcf", ".gcf");
            this.automaton2ETF(hypothesis, inputs, etf);
        }
        catch (IOException ioe) {
            throw new ModelCheckingException((Exception)ioe);
        }
        ArrayList ltsminCommandLine = Lists.newArrayList((Object[])new String[]{LTSminUtil.ETF2LTS_MC, etf.getAbsolutePath(), "--ltl=" + formula, "--trace=" + gcf.getAbsolutePath(), "--threads=1", "--ltl-semantics=ltsmin", "--allow-undefined-edges"});
        if (LTSminUtil.isVerbose()) {
            ltsminCommandLine.add("-v");
        }
        ltsminCommandLine.addAll(this.getExtraCommandLineOptions());
        int ltsminExitValue = AbstractLTSmin.runCommandLine(ltsminCommandLine);
        if (!this.keepFiles && !etf.delete()) {
            throw new ModelCheckingException("Could not delete file: " + etf.getAbsolutePath());
        }
        if (ltsminExitValue == 1) {
            int convertExitValue;
            try {
                fsm = File.createTempFile("gcf2fsm", ".fsm");
            }
            catch (IOException ioe) {
                throw new ModelCheckingException((Exception)ioe);
            }
            ArrayList convertCommandLine = Lists.newArrayList((Object[])new String[]{LTSminUtil.LTSMIN_CONVERT, gcf.getAbsolutePath(), fsm.getAbsolutePath(), "--rdwr"});
            if (LTSminUtil.isVerbose()) {
                convertCommandLine.add("-v");
            }
            if ((convertExitValue = AbstractLTSmin.runCommandLine(convertCommandLine)) != 0) {
                String msg = LOGGER.isDebugEnabled() ? "Could not convert GCF to FSM, please check LTSmin's debug information to see why." : "Could not convert GCF to FSM, to see why, enable debug logging.";
                throw new ModelCheckingException(msg);
            }
        } else {
            if (ltsminExitValue != 0) {
                String msg = LOGGER.isDebugEnabled() ? "Could not model check ETF, please check LTSmin's debug information to see why." : "Could not model check ETF, to see why, enable debug logging.";
                throw new ModelCheckingException(msg);
            }
            fsm = null;
        }
        if (!this.keepFiles && !gcf.delete()) {
            throw new ModelCheckingException("Could not delete file: " + gcf.getAbsolutePath());
        }
        return fsm;
    }

    static int runCommandLine(List<String> commandLine) throws ModelCheckingException {
        CharSequence[] commands = new String[commandLine.size()];
        commandLine.toArray(commands);
        try {
            LOGGER.debug("Invoking LTSmin binary as: {}", (Object)String.join((CharSequence)" ", commands));
            return ProcessUtil.invokeProcess((String[])commands, arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        catch (IOException | InterruptedException e) {
            throw new ModelCheckingException(e);
        }
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean keepFiles() {
            return false;
        }
    }
}

