/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.fsa.impl.CompactDFA;
import net.automatalib.exception.FormatException;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelchecker.ltsmin.LTSminDFA;
import net.automatalib.modelchecker.ltsmin.LTSminLTLParser;
import net.automatalib.modelchecker.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.serialization.fsm.parser.FSM2DFAParser;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTSminMonitorDFA<I>
extends AbstractLTSminMonitor<I, DFA<?, I>, DFA<?, I>>
implements LTSminDFA<I, DFA<?, I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminMonitorDFA.class);

    public LTSminMonitorDFA(boolean keepFiles, Function<String, I> string2Input) {
        super(keepFiles, string2Input);
    }

    @Override
    protected void verifyFormula(String formula) throws FormatException {
        LTSminLTLParser.requireValidLetterFormula(formula);
    }

    public @Nullable DFA<?, I> findCounterExample(DFA<?, I> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            CompactDFA result = (CompactDFA)FSM2DFAParser.getParser(inputs, this.getString2Input(), (String)"label", (String)"accept").readModel(fsm);
            for (Integer state : result) {
                boolean deadlocks = inputs.stream().noneMatch(i -> result.getSuccessor((Object)state, i) != null);
                result.setAccepting(state, deadlocks);
            }
            Iterator iterator = result;
            return iterator;
        }
        catch (IOException | FormatException e) {
            throw new ModelCheckingException((Exception)e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: '{}'", (Object)fsm.getAbsolutePath());
            }
        }
    }
}

