/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automaton.impl.CompactTransition;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.exception.FormatException;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelchecker.ltsmin.LTSminLTLParser;
import net.automatalib.modelchecker.ltsmin.LTSminMealy;
import net.automatalib.modelchecker.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLTSminMonitorMealy<I, O>
extends AbstractLTSminMonitor<I, MealyMachine<?, I, ?, O>, MealyMachine<?, I, ?, O>>
implements LTSminMealy<I, O, MealyMachine<?, I, ?, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLTSminMonitorMealy.class);
    private final Function<String, O> string2Output;
    private Collection<? super O> skipOutputs;

    protected AbstractLTSminMonitorMealy(boolean keepFiles, Function<String, I> string2Input, Function<String, O> string2Output, Collection<? super O> skipOutputs) {
        super(keepFiles, string2Input);
        this.string2Output = string2Output;
        this.skipOutputs = skipOutputs;
    }

    @Override
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    @Override
    protected void verifyFormula(String formula) throws FormatException {
        LTSminLTLParser.requireValidIOFormula(formula);
    }

    public @Nullable MealyMachine<?, I, ?, O> findCounterExample(MealyMachine<?, I, ?, O> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            final CompactMealy result = this.fsm2Mealy(fsm, automaton, inputs);
            final Integer deadlock = result.getStates().stream().filter(s -> inputs.stream().allMatch(i -> result.getSuccessor(s, i) == null)).findFirst().orElseThrow(() -> new ModelCheckingException("No deadlock found"));
            MealyMachine mealyMachine = new MealyMachine<Integer, I, CompactTransition<O>, O>(){

                public Word<O> computeStateOutput(Integer state, Iterable<? extends I> input) {
                    Integer succ = (Integer)this.getSuccessor(state, input);
                    return deadlock.equals(succ) ? super.computeStateOutput((Object)state, input) : null;
                }

                public @Nullable Integer getInitialState() {
                    return result.getInitialState();
                }

                public Integer getSuccessor(CompactTransition<O> transition) {
                    return result.getSuccessor(transition);
                }

                public @Nullable CompactTransition<O> getTransition(Integer state, I input) {
                    return (CompactTransition)result.getTransition(state, input);
                }

                public O getTransitionOutput(CompactTransition<O> transition) {
                    return result.getTransitionOutput(transition);
                }

                public Collection<Integer> getStates() {
                    return result.getStates();
                }
            };
            return mealyMachine;
        }
        catch (IOException | FormatException e) {
            throw new ModelCheckingException((Exception)e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: '{}'", (Object)fsm.getAbsolutePath());
            }
        }
    }
}

