package net.automatalib.modelchecker.ltsmin.monitor;

import de.learnlib.tooling.annotation.Generated;
import java.lang.String;
import java.util.Collection;
import java.util.function.Function;

/**
 * A builder for constructing {@link LTSminMonitorIO} instances.
 * @param <I> the input type
 * @param <O> the output type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.builder.BuilderProcessor",
        source = "net.automatalib.modelchecker.ltsmin.monitor.LTSminMonitorIO"
)
public final class LTSminMonitorIOBuilder<I, O> {
    private boolean keepFiles;

    private Function<String, I> string2Input;

    private Function<String, O> string2Output;

    private Collection<? super O> skipOutputs;

    /**
     * Creates a new builder (and may set default values for some parameters).
     */
    public LTSminMonitorIOBuilder() {
        this.keepFiles = net.automatalib.modelchecker.ltsmin.monitor.AbstractLTSminMonitor.BuilderDefaults.keepFiles();
        this.skipOutputs = net.automatalib.modelchecker.ltsmin.monitor.AbstractLTSminMonitor.BuilderDefaults.skipOutputs();
    }

    /**
     * Returns the current value for the parameter {@code keepFiles}.
     * @return the current value for the parameter {@code keepFiles}
     */
    public boolean getKeepFiles() {
        return this.keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles}.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     */
    public void setKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles} and returns {@code this} builder instance.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     * @return the current builder instance
     */
    public LTSminMonitorIOBuilder<I, O> withKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code string2Input}.
     * @return the current value for the parameter {@code string2Input}
     */
    public Function<String, I> getString2Input() {
        return this.string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input}.
     * @param string2Input the new value for the parameter {@code string2Input}
     */
    public void setString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input} and returns {@code this} builder instance.
     * @param string2Input the new value for the parameter {@code string2Input}
     * @return the current builder instance
     */
    public LTSminMonitorIOBuilder<I, O> withString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code string2Output}.
     * @return the current value for the parameter {@code string2Output}
     */
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    /**
     * Sets the new value for the parameter {@code string2Output}.
     * @param string2Output the new value for the parameter {@code string2Output}
     */
    public void setString2Output(Function<String, O> string2Output) {
        this.string2Output = string2Output;
    }

    /**
     * Sets the new value for the parameter {@code string2Output} and returns {@code this} builder instance.
     * @param string2Output the new value for the parameter {@code string2Output}
     * @return the current builder instance
     */
    public LTSminMonitorIOBuilder<I, O> withString2Output(Function<String, O> string2Output) {
        this.string2Output = string2Output;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code skipOutputs}.
     * @return the current value for the parameter {@code skipOutputs}
     */
    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    /**
     * Sets the new value for the parameter {@code skipOutputs}.
     * @param skipOutputs the new value for the parameter {@code skipOutputs}
     */
    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    /**
     * Sets the new value for the parameter {@code skipOutputs} and returns {@code this} builder instance.
     * @param skipOutputs the new value for the parameter {@code skipOutputs}
     * @return the current builder instance
     */
    public LTSminMonitorIOBuilder<I, O> withSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
        return this;
    }

    /**
     * Creates a new {@link LTSminMonitorIO} instance with the configured parameters.
     * @return the created instance
     */
    public LTSminMonitorIO<I, O> create() {
        return new LTSminMonitorIO<I, O>(keepFiles, string2Input, string2Output, skipOutputs);
    }
}
