package net.automatalib.modelchecker.ltsmin.ltl;

import de.learnlib.tooling.annotation.Generated;
import java.lang.String;
import java.util.function.Function;

/**
 * A builder for constructing {@link LTSminLTLDFA} instances.
 * @param <I> the input type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.builder.BuilderProcessor",
        source = "net.automatalib.modelchecker.ltsmin.ltl.LTSminLTLDFA"
)
public final class LTSminLTLDFABuilder<I> {
    private boolean keepFiles;

    private Function<String, I> string2Input;

    private int minimumUnfolds;

    private double multiplier;

    /**
     * Creates a new builder (and may set default values for some parameters).
     */
    public LTSminLTLDFABuilder() {
        this.keepFiles = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.keepFiles();
        this.minimumUnfolds = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.minimumUnfolds();
        this.multiplier = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.multiplier();
    }

    /**
     * Returns the current value for the parameter {@code keepFiles}.
     * @return the current value for the parameter {@code keepFiles}
     */
    public boolean getKeepFiles() {
        return this.keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles}.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     */
    public void setKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles} and returns {@code this} builder instance.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     * @return the current builder instance
     */
    public LTSminLTLDFABuilder<I> withKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code string2Input}.
     * @return the current value for the parameter {@code string2Input}
     */
    public Function<String, I> getString2Input() {
        return this.string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input}.
     * @param string2Input the new value for the parameter {@code string2Input}
     */
    public void setString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input} and returns {@code this} builder instance.
     * @param string2Input the new value for the parameter {@code string2Input}
     * @return the current builder instance
     */
    public LTSminLTLDFABuilder<I> withString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code minimumUnfolds}.
     * @return the current value for the parameter {@code minimumUnfolds}
     */
    public int getMinimumUnfolds() {
        return this.minimumUnfolds;
    }

    /**
     * Sets the new value for the parameter {@code minimumUnfolds}.
     * @param minimumUnfolds the new value for the parameter {@code minimumUnfolds}
     */
    public void setMinimumUnfolds(int minimumUnfolds) {
        this.minimumUnfolds = minimumUnfolds;
    }

    /**
     * Sets the new value for the parameter {@code minimumUnfolds} and returns {@code this} builder instance.
     * @param minimumUnfolds the new value for the parameter {@code minimumUnfolds}
     * @return the current builder instance
     */
    public LTSminLTLDFABuilder<I> withMinimumUnfolds(int minimumUnfolds) {
        this.minimumUnfolds = minimumUnfolds;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code multiplier}.
     * @return the current value for the parameter {@code multiplier}
     */
    public double getMultiplier() {
        return this.multiplier;
    }

    /**
     * Sets the new value for the parameter {@code multiplier}.
     * @param multiplier the new value for the parameter {@code multiplier}
     */
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    /**
     * Sets the new value for the parameter {@code multiplier} and returns {@code this} builder instance.
     * @param multiplier the new value for the parameter {@code multiplier}
     * @return the current builder instance
     */
    public LTSminLTLDFABuilder<I> withMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    /**
     * Creates a new {@link LTSminLTLDFA} instance with the configured parameters.
     * @return the created instance
     */
    public LTSminLTLDFA<I> create() {
        return new LTSminLTLDFA<I>(keepFiles, string2Input, minimumUnfolds, multiplier);
    }
}
