/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.algorithms.graph;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.algorithms.graph.apsp.APSPResult;
import net.automatalib.algorithms.graph.apsp.FloydWarshallAPSP;
import net.automatalib.algorithms.graph.scc.SCCListener;
import net.automatalib.algorithms.graph.scc.SCCs;
import net.automatalib.algorithms.graph.sssp.DijkstraSSSP;
import net.automatalib.algorithms.graph.sssp.SSSPResult;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.EdgeWeights;

public class GraphAlgorithms {
    public static final float INVALID_DISTANCE = Float.NEGATIVE_INFINITY;

    public static <N, E> List<N> toNodeList(List<E> edgeList, Graph<N, E> graph, N init) {
        ArrayList<Object> result = new ArrayList<Object>(edgeList.size() + 1);
        result.add(init);
        for (E edge : edgeList) {
            Object tgt = graph.getTarget(edge);
            result.add(tgt);
        }
        return result;
    }

    public static <N, E> APSPResult<N, E> findAPSP(Graph<N, E> graph, EdgeWeights<E> edgeWeights) {
        return FloydWarshallAPSP.findAPSP(graph, edgeWeights);
    }

    public static <N, E> SSSPResult<N, E> findSSSP(Graph<N, E> graph, N init, EdgeWeights<E> edgeWeights) {
        return DijkstraSSSP.findSSSP(graph, init, edgeWeights);
    }

    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        return SCCs.collectSCCs(graph);
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> sccListener) {
        SCCs.findSCCs(graph, sccListener);
    }
}

