/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.algorithms.graph.scc;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.algorithms.graph.scc.SCCListener;
import net.automatalib.algorithms.graph.scc.TarjanSCCRecord;
import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;
import net.automatalib.util.graphs.traversal.GraphTraversalVisitor;

public class TarjanSCCVisitor<N, E>
implements GraphTraversalVisitor<N, E, TarjanSCCRecord> {
    private static final int NODE_FINISHED = -1;
    private int counter = 0;
    private final MutableMapping<N, TarjanSCCRecord> records;
    private final List<N> currentScc = new ArrayList<N>();
    private final SCCListener<N> listener;

    public TarjanSCCVisitor(Graph<N, E> graph, SCCListener<N> listener) {
        this.records = graph.createStaticNodeMapping();
        this.listener = listener;
    }

    public GraphTraversalAction processInitial(N initialNode, Holder<TarjanSCCRecord> outData) {
        outData.value = this.createRecord();
        return GraphTraversalAction.EXPLORE;
    }

    public boolean startExploration(N node, TarjanSCCRecord data) {
        this.records.put(node, (Object)data);
        return true;
    }

    public void finishExploration(N node, TarjanSCCRecord data) {
        this.currentScc.add(node);
        if (data.lowLink == data.number) {
            this.listener.foundSCC(this.currentScc);
            this.currentScc.clear();
        }
        data.lowLink = -1;
    }

    public GraphTraversalAction processEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, Holder<TarjanSCCRecord> dataHolder) {
        int tgtNum;
        TarjanSCCRecord rec = (TarjanSCCRecord)this.records.get(tgtNode);
        if (rec == null) {
            rec = this.createRecord();
            dataHolder.value = rec;
            return GraphTraversalAction.EXPLORE;
        }
        if (rec.lowLink != -1 && (tgtNum = rec.number) < srcData.lowLink) {
            srcData.lowLink = tgtNum;
        }
        return GraphTraversalAction.IGNORE;
    }

    public void backtrackEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, TarjanSCCRecord tgtData) {
        int tgtLl = tgtData.lowLink;
        if (tgtLl < srcData.lowLink) {
            srcData.lowLink = tgtLl;
        }
    }

    public boolean hasVisited(N node) {
        return this.records.get(node) != null;
    }

    private TarjanSCCRecord createRecord() {
        return new TarjanSCCRecord(this.counter++);
    }
}

