/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.jung;

import com.github.misberner.graphvizawtshapes.ShapeLibrary;
import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import net.automatalib.visualization.helper.AggregateVisualizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JungGraphVisualizationProvider
implements VisualizationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JungGraphVisualizationProvider.class);
    private final PluggableGraphMouse mouse;

    public JungGraphVisualizationProvider() {
        float zoomScaling = 1.1f;
        this.mouse = new PluggableGraphMouse();
        this.mouse.add((GraphMousePlugin)new PickingGraphMousePlugin());
        this.mouse.add((GraphMousePlugin)new TranslatingGraphMousePlugin(4));
        this.mouse.add((GraphMousePlugin)new ScalingGraphMousePlugin((ScalingControl)new CrossoverScalingControl(), 0, 0.9090909f, 1.1f));
    }

    public String getId() {
        return "jung";
    }

    public boolean checkUsable() {
        return true;
    }

    public <N, E> void visualize(Graph<N, E> graph, List<VisualizationHelper<N, ? super E>> additionalHelpers, boolean modal, Map<String, String> options) {
        DirectedGraph<NodeVisualization, EdgeVisualization> visGraph = JungGraphVisualizationProvider.createVisualizationGraph(graph, additionalHelpers);
        KKLayout layout = new KKLayout(visGraph);
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        JungGraphVisualizationProvider.setupRenderContext((RenderContext<NodeVisualization, EdgeVisualization>)vv.getRenderContext());
        JungGraphVisualizationProvider.setupRenderer((Renderer<NodeVisualization, EdgeVisualization>)vv.getRenderer());
        vv.setGraphMouse((VisualizationViewer.GraphMouse)this.mouse);
        JDialog frame = new JDialog((Dialog)null, "Visualization", modal);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }

    public static <N, E> DirectedGraph<NodeVisualization, EdgeVisualization> createVisualizationGraph(Graph<N, E> graph, List<VisualizationHelper<N, ? super E>> additionalHelpers) {
        AggregateVisualizationHelper helper = new AggregateVisualizationHelper(graph.getVisualizationHelper(), additionalHelpers);
        HashMap defaultProps = new HashMap();
        helper.getGlobalNodeProperties(defaultProps);
        DirectedSparseMultigraph jungGraph = new DirectedSparseMultigraph();
        MutableMapping mapping = graph.createStaticNodeMapping();
        NodeIDs nodeIds = graph.nodeIDs();
        for (Object node : graph) {
            int id = nodeIds.getNodeId(node);
            HashMap<String, String> props = new HashMap<String, String>(defaultProps);
            helper.getNodeProperties(node, props);
            NodeVisualization vis = JungGraphVisualizationProvider.createNodeVisualization(props, id);
            mapping.put(node, (Object)vis);
        }
        defaultProps = new HashMap();
        helper.getGlobalEdgeProperties(defaultProps);
        for (Object node : graph) {
            NodeVisualization srcVis = (NodeVisualization)mapping.get(node);
            for (Object edge : graph.getOutgoingEdges(node)) {
                Object target = graph.getTarget(edge);
                NodeVisualization tgtVis = (NodeVisualization)mapping.get(target);
                HashMap<String, String> props = new HashMap<String, String>(defaultProps);
                helper.getEdgeProperties(node, edge, target, props);
                EdgeVisualization edgeVis = JungGraphVisualizationProvider.createEdgeVisualization(props);
                jungGraph.addEdge((Object)edgeVis, (Object)srcVis, (Object)tgtVis);
            }
        }
        return jungGraph;
    }

    public static void setupRenderContext(RenderContext<NodeVisualization, EdgeVisualization> ctx) {
        ctx.setVertexLabelTransformer(NodeVisualization.LABEL);
        ctx.setVertexDrawPaintTransformer(NodeVisualization.DRAW_COLOR);
        ctx.setVertexFillPaintTransformer(NodeVisualization.FILL_COLOR);
        ctx.setVertexShapeTransformer(NodeVisualization.SHAPE);
        ctx.setVertexStrokeTransformer(NodeVisualization.STROKE);
        ctx.setEdgeLabelTransformer(EdgeVisualization.LABEL);
        ctx.setEdgeDrawPaintTransformer(EdgeVisualization.DRAW_COLOR);
        ctx.setEdgeStrokeTransformer(EdgeVisualization.STROKE);
    }

    public static void setupRenderer(Renderer<NodeVisualization, EdgeVisualization> renderer) {
        renderer.getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
    }

    protected static NodeVisualization createNodeVisualization(Map<String, String> props, int id) {
        ShapeLibrary shapeLib;
        Shape shape;
        String label = props.get("label");
        if (label == null) {
            label = "v" + id;
        }
        Color drawColor = JungGraphVisualizationProvider.getColor(props, "color", Color.BLACK);
        Color fillColor = JungGraphVisualizationProvider.getColor(props, "fillcolor", Color.WHITE);
        String shapeName = props.get("shape");
        if (shapeName == null) {
            shapeName = "circle";
        }
        if ((shape = (shapeLib = ShapeLibrary.getInstance()).createShape(shapeName)) == null) {
            LOGGER.error("Could not create shape {}", (Object)shapeName);
            shape = shapeLib.createShape("circle");
        }
        Stroke stroke = JungGraphVisualizationProvider.getStroke(props);
        return new NodeVisualization(label, drawColor, fillColor, shape, stroke);
    }

    protected static EdgeVisualization createEdgeVisualization(Map<String, String> props) {
        String label = props.get("label");
        if (label == null) {
            label = "";
        }
        Color drawColor = JungGraphVisualizationProvider.getColor(props, "color", Color.BLACK);
        Stroke stroke = JungGraphVisualizationProvider.getStroke(props);
        return new EdgeVisualization(label, drawColor, stroke);
    }

    protected static Color getColor(Map<String, String> props, String propName, Color defColor) {
        String colName = props.get(propName);
        if (colName == null) {
            return defColor;
        }
        Color col = Color.getColor(colName);
        if (col == null) {
            return defColor;
        }
        return col;
    }

    private static Stroke getStroke(Map<String, String> properties) {
        String styleAttr = properties.get("style");
        List<Object> styleList = styleAttr != null ? Arrays.asList(styleAttr.toLowerCase().split(",")) : Collections.emptyList();
        float penWidth = 1.0f;
        if (styleList.contains("bold")) {
            penWidth = 3.0f;
        }
        float miterLimit = 10.0f;
        if (styleList.contains("dashed")) {
            float[] dash = new float[]{10.0f};
            return new BasicStroke(penWidth, 0, 0, 10.0f, dash, 0.0f);
        }
        if (styleList.contains("dotted")) {
            float[] dotted = new float[]{penWidth, 10.0f};
            return new BasicStroke(penWidth, 0, 0, 10.0f, dotted, 0.0f);
        }
        return new BasicStroke(penWidth);
    }

    public static final class EdgeVisualization {
        public static final Function<EdgeVisualization, String> LABEL = input -> input.label;
        public static final Function<EdgeVisualization, Paint> DRAW_COLOR = input -> input.drawColor;
        public static final Function<EdgeVisualization, Stroke> STROKE = input -> input.stroke;
        public final String label;
        public final Color drawColor;
        public final Stroke stroke;

        public EdgeVisualization(String label, Color drawColor, Stroke stroke) {
            this.label = label;
            this.drawColor = drawColor;
            this.stroke = stroke;
        }
    }

    public static final class NodeVisualization {
        public static final Function<NodeVisualization, String> LABEL = input -> input.label;
        public static final Function<NodeVisualization, Paint> DRAW_COLOR = input -> input.color;
        public static final Function<NodeVisualization, Paint> FILL_COLOR = input -> input.fillColor;
        public static final Function<NodeVisualization, Shape> SHAPE = input -> input.shape;
        public static final Function<NodeVisualization, Stroke> STROKE = input -> input.stroke;
        public final String label;
        public final Color color;
        public final Color fillColor;
        public final Shape shape;
        public final Stroke stroke;

        public NodeVisualization(String label, Color drawColor, Color fillColor, Shape shape, Stroke stroke) {
            this.label = label;
            this.color = drawColor;
            this.fillColor = fillColor;
            this.shape = shape;
            this.stroke = stroke;
        }
    }
}

