/* Copyright (C) 2013-2018 TU Dortmund
 * This file is part of AutomataLib, http://www.automatalib.net/.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.automatalib.incremental.dfa.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import net.automatalib.incremental.dfa.Acceptance;

@ParametersAreNonnullByDefault
public final class Edge<I> {

    private final Node<I> node;
    private final I input;

    public Edge(Node<I> node, @Nullable I input) {
        this.node = node;
        this.input = input;
    }

    @Nonnull
    public Node<I> getNode() {
        return node;
    }

    @Nullable
    public I getInput() {
        return input;
    }

    @Nonnull
    public Acceptance getAcceptance() {
        return node.getAcceptance();
    }
}
