/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.util.Objects;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.tree.Edge;

final class Node<I, O> {
    private final Edge<I, O>[] outEdges;

    public Node(int alphabetSize) {
        this.outEdges = new Edge[alphabetSize];
    }

    public Edge<I, O> getEdge(int idx) {
        return this.outEdges[idx];
    }

    public void setEdge(int idx, Edge<I, O> edge) {
        this.outEdges[idx] = edge;
    }

    public void setSuccessor(int idx, O output, Node<I, O> succ) {
        this.outEdges[idx] = new Edge<I, O>(output, succ);
    }

    public Node<I, O> getSuccessor(int idx) {
        Edge<I, O> edge = this.outEdges[idx];
        if (edge != null) {
            return edge.getTarget();
        }
        return null;
    }

    public Node<I, O> successor(int idx, O output) throws ConflictException {
        Edge<I, O> edge = this.outEdges[idx];
        if (edge != null) {
            if (!Objects.equals(output, edge.getOutput())) {
                throw new ConflictException("Output mismatch: '" + output + "' vs '" + edge.getOutput() + "'");
            }
            return edge.getTarget();
        }
        Node<I, O> succ = new Node<I, O>(this.outEdges.length);
        edge = new Edge<I, O>(output, succ);
        this.outEdges[idx] = edge;
        return succ;
    }
}

