/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.dot.DelegateDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.AbstractIncrementalMealyBuilder;
import net.automatalib.incremental.mealy.tree.AnnotatedEdge;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.Node;
import net.automatalib.ts.transout.MealyTransitionSystem;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class IncrementalMealyTreeBuilder<I, O>
extends AbstractIncrementalMealyBuilder<I, O> {
    private final Node<I, O> root;

    public IncrementalMealyTreeBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
        this.root = new Node(inputAlphabet.size());
    }

    @Override
    public void insert(Word<? extends I> input, Word<? extends O> outputWord) throws ConflictException {
        Node<I, O> curr = this.root;
        Iterator outputIt = outputWord.iterator();
        for (Object sym : input) {
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Object out = outputIt.next();
            Edge<I, O> edge = curr.getEdge(symIdx);
            if (edge == null) {
                curr = this.insertNode(curr, symIdx, out);
                continue;
            }
            if (!Objects.equal(out, edge.getOutput())) {
                throw new ConflictException();
            }
            curr = curr.getSuccessor(symIdx);
        }
    }

    @Override
    public boolean lookup(Word<? extends I> word, List<? super O> output) {
        Node<I, O> curr = this.root;
        for (Object sym : word) {
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Edge<I, O> edge = curr.getEdge(symIdx);
            if (edge == null) {
                return false;
            }
            output.add(edge.getOutput());
            curr = edge.getTarget();
        }
        return true;
    }

    @Override
    public Word<I> findSeparatingWord(MealyMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        int symIdx;
        Node<I, O> curr;
        Iterator symIt = word.iterator();
        for (curr = this.root; symIt.hasNext() && curr != null; curr = curr.getSuccessor(symIdx)) {
            symIdx = this.inputAlphabet.getSymbolIndex(symIt.next());
        }
        return curr != null;
    }

    private <S, T> Word<I> doFindSeparatingWord(MealyMachine<S, I, T, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        ArrayDeque dfsStack = new ArrayDeque();
        dfsStack.push(new Record<Object, I, O>(target.getInitialState(), this.root, null, inputs.iterator()));
        while (!dfsStack.isEmpty()) {
            Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            int inputIdx = this.inputAlphabet.getSymbolIndex(input);
            Edge edge = rec.treeNode.getEdge(inputIdx);
            if (edge == null) continue;
            Object trans = target.getTransition(rec.automatonState, input);
            if (omitUndefined && trans == null) continue;
            if (trans == null || !Objects.equal((Object)target.getTransitionOutput(trans), edge.getOutput())) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                do {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                } while (!dfsStack.isEmpty());
                return wb.reverse().toWord();
            }
            dfsStack.push(new Record(target.getSuccessor(trans), edge.getTarget(), input, inputs.iterator()));
        }
        return null;
    }

    private Node<I, O> insertNode(Node<I, O> parent, int symIdx, O output) {
        Node succ = new Node(this.inputAlphabet.size());
        Edge edge = new Edge(output, succ);
        parent.setEdge(symIdx, edge);
        return succ;
    }

    public TransitionSystemView asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public GraphView asGraph() {
        return new GraphView();
    }

    public class TransitionSystemView
    implements MealyTransitionSystem<Node<I, O>, I, Edge<I, O>, O> {
        public Edge<I, O> getTransition(Node<I, O> state, I input) {
            int inputIdx = IncrementalMealyTreeBuilder.this.inputAlphabet.getSymbolIndex(input);
            return state.getEdge(inputIdx);
        }

        public Node<I, O> getSuccessor(Edge<I, O> transition) {
            return transition.getTarget();
        }

        public Node<I, O> getInitialState() {
            return IncrementalMealyTreeBuilder.this.root;
        }

        public O getTransitionOutput(Edge<I, O> transition) {
            return transition.getOutput();
        }
    }

    public class GraphView
    extends AbstractIncrementalMealyBuilder.AbstractGraphView<I, O, Node<I, O>, AnnotatedEdge<I, O>> {
        public Collection<Node<I, O>> getNodes() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, (Iterator)GraphTraversal.dfIterator((IndefiniteGraph)this, Collections.singleton(IncrementalMealyTreeBuilder.this.root)));
            return result;
        }

        public Collection<AnnotatedEdge<I, O>> getOutgoingEdges(Node<I, O> node) {
            ArrayList result = new ArrayList();
            for (int i = 0; i < IncrementalMealyTreeBuilder.this.inputAlphabet.size(); ++i) {
                Edge edge = node.getEdge(i);
                if (edge == null) continue;
                result.add(new AnnotatedEdge(edge, IncrementalMealyTreeBuilder.this.inputAlphabet.getSymbol(i)));
            }
            return result;
        }

        public Node<I, O> getTarget(AnnotatedEdge<I, O> edge) {
            return edge.getTarget();
        }

        @Override
        @Nonnull
        public Node<I, O> getInitialNode() {
            return IncrementalMealyTreeBuilder.this.root;
        }

        @Override
        @Nullable
        public I getInputSymbol(AnnotatedEdge<I, O> edge) {
            return edge.getInput();
        }

        @Override
        @Nullable
        public O getOutputSymbol(AnnotatedEdge<I, O> edge) {
            return edge.getOutput();
        }

        @Override
        public GraphDOTHelper<Node<I, O>, AnnotatedEdge<I, O>> getGraphDOTHelper() {
            return new DelegateDOTHelper<Node<I, O>, AnnotatedEdge<I, O>>(super.getGraphDOTHelper()){
                private int id;
                {
                    this.id = 0;
                }

                public boolean getNodeProperties(Node<I, O> node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    properties.put("label", "n" + this.id++);
                    return true;
                }
            };
        }
    }

    private static final class Record<S, I, O> {
        private final S automatonState;
        private final Node<I, O> treeNode;
        private final I incomingInput;
        private final Iterator<? extends I> inputIt;

        public Record(S automatonState, Node<I, O> treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.inputIt = inputIt;
            this.incomingInput = incomingInput;
        }
    }
}

