/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import java.util.Arrays;
import java.util.Objects;
import net.automatalib.incremental.mealy.dag.State;

final class StateSignature {
    public final State[] successors;
    public final Object[] outputs;
    private int hashCode;

    public StateSignature(int numSuccs) {
        this.successors = new State[numSuccs];
        this.outputs = new Object[numSuccs];
    }

    public StateSignature(StateSignature other) {
        this.successors = (State[])other.successors.clone();
        this.outputs = (Object[])other.outputs.clone();
    }

    public StateSignature duplicate() {
        return new StateSignature(this);
    }

    public void updateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.outputs);
        this.hashCode = result = 31 * result + Arrays.hashCode(this.successors);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != StateSignature.class) {
            return false;
        }
        StateSignature other = (StateSignature)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        for (i = 0; i < this.successors.length; ++i) {
            if (this.successors[i] == other.successors[i]) continue;
            return false;
        }
        for (i = 0; i < this.outputs.length; ++i) {
            if (Objects.equals(this.outputs[i], other.outputs[i])) continue;
            return false;
        }
        return true;
    }
}

