/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.UnionFind;
import net.automatalib.graphs.dot.DelegateDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.AbstractIncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.PathElem;
import net.automatalib.incremental.mealy.dag.State;
import net.automatalib.incremental.mealy.dag.StateSignature;
import net.automatalib.incremental.mealy.dag.TransitionRecord;
import net.automatalib.ts.transout.MealyTransitionSystem;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class IncrementalMealyDAGBuilder<I, O>
extends AbstractIncrementalMealyBuilder<I, O> {
    private final Map<StateSignature, State> register = new HashMap<StateSignature, State>();
    private final int alphabetSize;
    private final State init;

    public IncrementalMealyDAGBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
        this.alphabetSize = inputAlphabet.size();
        StateSignature initSig = new StateSignature(this.alphabetSize);
        this.init = new State(initSig);
        this.register.put(null, this.init);
    }

    private State getState(Word<? extends I> word) {
        Object sym;
        int idx;
        State s = this.init;
        Iterator iterator = word.iterator();
        while (iterator.hasNext() && (s = s.getSuccessor(idx = this.inputAlphabet.getSymbolIndex(sym = iterator.next()))) != null) {
        }
        return s;
    }

    @Deprecated
    public boolean isComplete(Word<? extends I> word) {
        return this.hasDefinitiveInformation(word);
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        State s = this.getState(word);
        return s != null;
    }

    @Override
    public boolean lookup(Word<? extends I> word, List<? super O> output) {
        State curr = this.init;
        for (Object sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            State succ = curr.getSuccessor(idx);
            if (succ == null) {
                return false;
            }
            output.add(curr.getOutput(idx));
            curr = succ;
        }
        return true;
    }

    @Override
    public void insert(Word<? extends I> word, Word<? extends O> outputWord) {
        int idx;
        State state;
        PathElem next;
        int len = word.length();
        State curr = this.init;
        State conf = null;
        ArrayDeque<PathElem> path = new ArrayDeque<PathElem>();
        Iterator outWordIterator = outputWord.iterator();
        for (Object sym : word) {
            int idx2;
            State succ;
            if (conf == null && curr.isConfluence()) {
                conf = curr;
            }
            if ((succ = curr.getSuccessor(idx2 = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            Object outSym = outWordIterator.next();
            if (!Objects.equals(outSym, curr.getOutput(idx2))) {
                throw new ConflictException("Error inserting " + word.prefix(path.size() + 1) + " / " + outputWord.prefix(path.size() + 1) + ": Incompatible output symbols: " + outSym + " vs " + curr.getOutput(idx2));
            }
            path.push(new PathElem(curr, idx2));
            curr = succ;
        }
        State last = curr;
        int prefixLen = path.size();
        if (prefixLen == len) {
            return;
        }
        if (conf != null) {
            if (conf == last) {
                conf = null;
            }
            last = this.hiddenClone(last);
        } else if (last != this.init) {
            this.hide(last);
        }
        Word suffix = word.subWord(prefixLen);
        Word suffixOut = outputWord.subWord(prefixLen);
        Object sym = suffix.firstSymbol();
        int suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
        Object suffTransOut = suffixOut.firstSymbol();
        State suffixState = this.createSuffix(suffix.subWord(1), suffixOut.subWord(1));
        if (last != this.init) {
            last = this.unhide(last, suffTransIdx, suffixState, suffTransOut);
        } else {
            this.updateInitSignature(suffTransIdx, suffixState, suffTransOut);
        }
        if (path.isEmpty()) {
            return;
        }
        if (conf != null) {
            do {
                next = (PathElem)path.pop();
                state = next.state;
                idx = next.transIdx;
                last = state = this.clone(state, idx, last);
            } while (next.state != conf);
        }
        while (path.size() > 1) {
            next = (PathElem)path.pop();
            state = next.state;
            idx = next.transIdx;
            State updated = this.updateSignature(state, idx, last);
            if (state == updated) {
                return;
            }
            last = updated;
        }
        int finalIdx = ((PathElem)path.pop()).transIdx;
        this.updateInitSignature(finalIdx, last);
    }

    private void updateInitSignature(int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = sig.successors[idx];
        if (oldSucc == succ) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
    }

    private State updateSignature(State state, int idx, State succ) {
        StateSignature sig = state.getSignature();
        if (sig.successors[idx] == succ) {
            return state;
        }
        this.register.remove(sig);
        if (sig.successors[idx] != null) {
            sig.successors[idx].decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    private State unhide(State state, int idx, State succ, O out) {
        StateSignature sig = state.getSignature();
        State prevSucc = sig.successors[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.outputs[idx] = out;
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    private void updateInitSignature(int idx, State succ, O out) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = sig.successors[idx];
        if (oldSucc == succ && Objects.equals(out, sig.outputs[idx])) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        sig.outputs[idx] = out;
        succ.increaseIncoming();
    }

    private State clone(State other, int idx, State succ) {
        StateSignature sig = other.getSignature();
        if (sig.successors[idx] == succ) {
            return other;
        }
        sig = sig.duplicate();
        sig.successors[idx] = succ;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    private State hiddenClone(State other) {
        StateSignature sig = other.getSignature().duplicate();
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = sig.successors[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return new State(sig);
    }

    private State replaceOrRegister(StateSignature sig) {
        State state = this.register.get(sig);
        if (state != null) {
            return state;
        }
        state = new State(sig);
        this.register.put(sig, state);
        for (int i = 0; i < sig.successors.length; ++i) {
            State succ = sig.successors[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return state;
    }

    private void hide(State state) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        this.register.remove(sig);
    }

    private State replaceOrRegister(State state) {
        StateSignature sig = state.getSignature();
        State other = this.register.get(sig);
        if (other != null) {
            if (state != other) {
                for (int i = 0; i < sig.successors.length; ++i) {
                    State succ = sig.successors[i];
                    if (succ == null) continue;
                    succ.decreaseIncoming();
                }
            }
            return other;
        }
        this.register.put(sig, state);
        return state;
    }

    private State createSuffix(Word<? extends I> suffix, Word<? extends O> suffixOut) {
        StateSignature sig = new StateSignature(this.alphabetSize);
        sig.updateHashCode();
        State last = this.replaceOrRegister(sig);
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            sig = new StateSignature(this.alphabetSize);
            Object sym = suffix.getSymbol(i);
            Object outsym = suffixOut.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            sig.successors[idx] = last;
            sig.outputs[idx] = outsym;
            sig.updateHashCode();
            last = this.replaceOrRegister(sig);
        }
        return last;
    }

    @Override
    public GraphView asGraph() {
        return new GraphView();
    }

    public AutomatonView asTransitionSystem() {
        return new AutomatonView();
    }

    @Override
    public Word<I> findSeparatingWord(MealyMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    private static int getStateId(State state, Map<State, Integer> ids) {
        Integer id = ids.get(state);
        if (id == null) {
            id = ids.size();
            ids.put(state, id);
        }
        return id;
    }

    private <S, T> Word<I> doFindSeparatingWord(MealyMachine<S, I, T, O> mealy, Collection<? extends I> inputs, boolean omitUndefined) {
        Record current;
        int thisStates = this.register.size();
        UnionFind uf = new UnionFind(thisStates + mealy.size());
        HashMap<State, Integer> ids = new HashMap<State, Integer>();
        State init1 = this.init;
        Object init2 = mealy.getInitialState();
        if (init2 == null) {
            return omitUndefined ? null : Word.epsilon();
        }
        StateIDs mealyIds = mealy.stateIDs();
        int id1 = IncrementalMealyDAGBuilder.getStateId(init1, ids);
        int id2 = mealyIds.getStateId(init2) + thisStates;
        uf.link(id1, id2);
        ArrayDeque<Record<Object, I>> queue = new ArrayDeque<Record<Object, I>>();
        queue.offer(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            State state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                Object out2;
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                State succ1 = state1.getSuccessor(idx);
                if (succ1 == null) continue;
                Object trans2 = mealy.getTransition(state2, sym);
                if (trans2 == null) {
                    if (omitUndefined) continue;
                    lastSym = sym;
                    break block0;
                }
                Object out1 = state1.getOutput(idx);
                if (!Objects.equals(out1, out2 = mealy.getTransitionOutput(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                Object succ2 = mealy.getSuccessor(trans2);
                id1 = IncrementalMealyDAGBuilder.getStateId(succ1, ids);
                id2 = mealyIds.getStateId(succ2) + thisStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                uf.link(r1, r2);
                queue.offer(new Record<Object, I>(succ1, succ2, current, sym));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            wb.setSymbol(--index, current.reachedVia);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    private static final class Record<S, I> {
        private final State state1;
        private final S state2;
        private final I reachedVia;
        private final Record<S, I> reachedFrom;
        private final int depth;

        public Record(State state1, S state2, Record<S, I> reachedFrom, I reachedVia) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedFrom = reachedFrom;
            this.reachedVia = reachedVia;
            this.depth = reachedFrom != null ? reachedFrom.depth + 1 : 0;
        }

        public Record(State state1, S state2) {
            this(state1, state2, null, null);
        }
    }

    public class AutomatonView
    implements MealyTransitionSystem<State, I, TransitionRecord, O> {
        public State getSuccessor(TransitionRecord transition) {
            State src = transition.source;
            return src.getSuccessor(transition.transIdx);
        }

        public State getInitialState() {
            return IncrementalMealyDAGBuilder.this.init;
        }

        public TransitionRecord getTransition(State state, I input) {
            int inputIdx = IncrementalMealyDAGBuilder.this.inputAlphabet.getSymbolIndex(input);
            if (state.getSuccessor(inputIdx) == null) {
                return null;
            }
            return new TransitionRecord(state, inputIdx);
        }

        public O getTransitionOutput(TransitionRecord transition) {
            State src = transition.source;
            return src.getOutput(transition.transIdx);
        }
    }

    public class GraphView
    extends AbstractIncrementalMealyBuilder.AbstractGraphView<I, O, State, TransitionRecord> {
        public Collection<TransitionRecord> getOutgoingEdges(State node) {
            ArrayList<TransitionRecord> edges = new ArrayList<TransitionRecord>();
            for (int i = 0; i < IncrementalMealyDAGBuilder.this.alphabetSize; ++i) {
                if (node.getSuccessor(i) == null) continue;
                edges.add(new TransitionRecord(node, i));
            }
            return edges;
        }

        public State getTarget(TransitionRecord edge) {
            return edge.source.getSuccessor(edge.transIdx);
        }

        public Collection<State> getNodes() {
            return Collections.unmodifiableCollection(IncrementalMealyDAGBuilder.this.register.values());
        }

        @Override
        @Nullable
        public I getInputSymbol(TransitionRecord edge) {
            return IncrementalMealyDAGBuilder.this.inputAlphabet.getSymbol(edge.transIdx);
        }

        @Override
        @Nullable
        public O getOutputSymbol(TransitionRecord edge) {
            return edge.source.getOutput(edge.transIdx);
        }

        @Override
        @Nonnull
        public State getInitialNode() {
            return IncrementalMealyDAGBuilder.this.init;
        }

        @Override
        public GraphDOTHelper<State, TransitionRecord> getGraphDOTHelper() {
            return new DelegateDOTHelper<State, TransitionRecord>(super.getGraphDOTHelper()){
                private int id;
                {
                    this.id = 0;
                }

                public boolean getNodeProperties(State node, Map<String, String> properties) {
                    if (!super.getNodeProperties((Object)node, properties)) {
                        return false;
                    }
                    properties.put("label", "n" + this.id++);
                    if (node.isConfluence()) {
                        properties.put("shape", "octagon");
                    }
                    return true;
                }
            };
        }
    }
}

