/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public abstract class AbstractIncrementalMealyBuilder<I, O>
implements IncrementalMealyBuilder<I, O> {
    protected Alphabet<I> inputAlphabet;

    public AbstractIncrementalMealyBuilder(Alphabet<I> alphabet) {
        this.inputAlphabet = alphabet;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        ArrayList unused = new ArrayList(word.length());
        return this.lookup(word, unused);
    }

    @Override
    public Word<O> lookup(Word<? extends I> inputWord) {
        WordBuilder wb = new WordBuilder(inputWord.size());
        this.lookup(inputWord, wb);
        return wb.toWord();
    }

    public static abstract class AbstractGraphView<I, O, N, E>
    implements IncrementalMealyBuilder.GraphView<I, O, N, E> {
        public GraphDOTHelper<N, E> getGraphDOTHelper() {
            return new DefaultDOTHelper<N, E>(){

                public Collection<? extends N> initialNodes() {
                    return Collections.singleton(this.getInitialNode());
                }

                public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    Object input = this.getInputSymbol(edge);
                    Object output = this.getOutputSymbol(edge);
                    properties.put("label", input + " / " + output);
                    return true;
                }
            };
        }
    }
}

