/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.incremental.dfa.tree.Node;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class IncrementalPCDFATreeBuilder<I>
extends IncrementalDFATreeBuilder<I> {
    private Node<I> sink = null;
    private int insertCount = 0;

    public IncrementalPCDFATreeBuilder(Alphabet<I> alphabet) {
        super(alphabet);
    }

    @Override
    public TransitionSystemView asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public Acceptance lookup(Word<? extends I> inputWord) {
        Node curr = this.root;
        for (Object sym : inputWord) {
            if (curr.getAcceptance() == Acceptance.FALSE) {
                return Acceptance.FALSE;
            }
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node succ = curr.getChild(symIdx);
            if (succ == null) {
                return Acceptance.DONT_KNOW;
            }
            curr = succ;
        }
        return curr.getAcceptance();
    }

    @Override
    public void insert(Word<? extends I> word, boolean acceptance) throws ConflictException {
        ++this.insertCount;
        if (acceptance) {
            this.insertTrue(word);
        } else {
            this.insertFalse(word);
        }
    }

    private void insertTrue(Word<? extends I> word) throws ConflictException {
        Node curr = this.root;
        int idx = 0;
        for (Object sym : word) {
            if (curr.getAcceptance() == Acceptance.FALSE) {
                throw new ConflictException("Conflicting acceptance values for word " + word.prefix(idx) + ": found FALSE, expected DONT_KNOW or TRUE");
            }
            curr.setAcceptance(Acceptance.TRUE);
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node succ = curr.getChild(symIdx);
            if (succ == null) {
                succ = new Node(Acceptance.TRUE);
                curr.setChild(symIdx, this.alphabetSize, succ);
            }
            curr = succ;
            ++idx;
        }
        if (curr.getAcceptance() == Acceptance.FALSE) {
            throw new ConflictException("Conflicting acceptance values for word " + word + ": found FALSE, expected DONT_KNOW or TRUE");
        }
        curr.setAcceptance(Acceptance.TRUE);
    }

    private void insertFalse(Word<? extends I> word) throws ConflictException {
        Node curr = this.root;
        Node prev = null;
        int lastSymIdx = -1;
        for (Object sym : word) {
            if (curr.getAcceptance() == Acceptance.FALSE) {
                return;
            }
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node succ = curr.getChild(symIdx);
            if (succ == null) {
                succ = new Node(Acceptance.DONT_KNOW);
                curr.setChild(symIdx, this.alphabetSize, succ);
            }
            prev = curr;
            curr = succ;
            lastSymIdx = symIdx;
        }
        if (curr.getAcceptance() == Acceptance.TRUE) {
            throw new ConflictException("Conflicting acceptance values for word " + word + ": found TRUE, expected DONT_KNOW or FALSE");
        }
        if (prev == null) {
            assert (curr == this.root);
            this.root.makeSink();
        } else {
            Node<I> sink = this.getSink();
            prev.setChild(lastSymIdx, this.alphabetSize, sink);
        }
    }

    @Override
    protected <S> Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Object automatonInit = target.getInitialState();
        Acceptance rootAcc = this.root.getAcceptance();
        if (rootAcc.conflicts(target.isAccepting(automatonInit))) {
            return Word.epsilon();
        }
        if (rootAcc == Acceptance.FALSE) {
            return IncrementalPCDFATreeBuilder.findLive(target, automatonInit, inputs, target.createStaticStateMapping());
        }
        ArrayDeque<IncrementalDFATreeBuilder.Record<Object, ? extends I>> dfsStack = new ArrayDeque<IncrementalDFATreeBuilder.Record<Object, ? extends I>>();
        dfsStack.push(new IncrementalDFATreeBuilder.Record<Object, I>(automatonInit, this.root, null, inputs.iterator()));
        MutableMapping deadStates = null;
        while (!dfsStack.isEmpty()) {
            Object automatonSucc;
            IncrementalDFATreeBuilder.Record rec = (IncrementalDFATreeBuilder.Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            int inputIdx = this.inputAlphabet.getSymbolIndex(input);
            Node succ = rec.treeNode.getChild(inputIdx);
            if (succ == null) continue;
            Acceptance acc = succ.getAcceptance();
            Object object = automatonSucc = rec.automatonState == null ? null : target.getTransition(rec.automatonState, input);
            if (automatonSucc == null && (omitUndefined || acc == Acceptance.FALSE)) continue;
            boolean succAcc = automatonSucc == null ? false : target.isAccepting(automatonSucc);
            Word<? extends I> liveSuffix = null;
            if (acc == Acceptance.FALSE) {
                if (deadStates == null) {
                    deadStates = target.createStaticStateMapping();
                }
                liveSuffix = IncrementalPCDFATreeBuilder.findLive(target, automatonSucc, inputs, deadStates);
            }
            if (acc.conflicts(succAcc) || liveSuffix != null) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                do {
                    wb.append(rec.incomingInput);
                    rec = (IncrementalDFATreeBuilder.Record)dfsStack.pop();
                } while (!dfsStack.isEmpty());
                wb.reverse();
                if (liveSuffix != null) {
                    wb.append(liveSuffix);
                }
                return wb.toWord();
            }
            dfsStack.push(new IncrementalDFATreeBuilder.Record<Object, I>(automatonSucc, succ, input, inputs.iterator()));
        }
        return null;
    }

    private static <S, I> Word<I> findLive(DFA<S, I> dfa, S state, Collection<? extends I> inputs, MutableMapping<S, Boolean> deadStates) {
        ArrayDeque<FindLiveRecord<Object, ? extends I>> dfsStack = new ArrayDeque<FindLiveRecord<Object, ? extends I>>();
        if (dfa.isAccepting(state)) {
            return Word.epsilon();
        }
        Boolean dead = (Boolean)deadStates.get(state);
        if (dead != null && dead.booleanValue()) {
            return null;
        }
        deadStates.put(state, (Object)true);
        dfsStack.push(new FindLiveRecord<S, I>(state, null, inputs.iterator()));
        while (!dfsStack.isEmpty()) {
            FindLiveRecord rec = (FindLiveRecord)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            Object succ = dfa.getTransition(rec.state, input);
            if (succ == null) continue;
            if (dfa.isAccepting(succ)) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (FindLiveRecord)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            dead = (Boolean)deadStates.get(succ);
            if (dead == null) {
                dfsStack.push(new FindLiveRecord<Object, I>(succ, input, inputs.iterator()));
                deadStates.put(succ, (Object)true);
                continue;
            }
            assert (dead.booleanValue());
        }
        return null;
    }

    public Node<I> getSink() {
        if (this.sink == null) {
            this.sink = new Node(Acceptance.FALSE);
        }
        return this.sink;
    }

    private static final class FindLiveRecord<S, I> {
        public final S state;
        public final I incomingInput;
        public final Iterator<? extends I> inputIt;

        public FindLiveRecord(S state, I incomingInput, Iterator<? extends I> inputIt) {
            this.state = state;
            this.incomingInput = incomingInput;
            this.inputIt = inputIt;
        }
    }

    public class TransitionSystemView
    extends IncrementalDFATreeBuilder.TransitionSystemView {
        @Override
        public Node<I> getTransition(Node<I> state, I input) {
            if (state.getAcceptance() == Acceptance.FALSE) {
                return state;
            }
            return super.getTransition(state, input);
        }
    }
}

