/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.commons.util.UnionFind;
import net.automatalib.graphs.dot.DelegateDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.EdgeRecord;
import net.automatalib.incremental.dfa.dag.State;
import net.automatalib.incremental.dfa.dag.StateSignature;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public abstract class AbstractIncrementalDFADAGBuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    protected final Map<StateSignature, State> register = new HashMap<StateSignature, State>();
    protected final State init;
    protected State sink;

    public AbstractIncrementalDFADAGBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
        StateSignature sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
        this.init = new State(sig);
        this.register.put(null, this.init);
    }

    @Override
    public Word<I> findSeparatingWord(DFA<?, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    private static int getStateId(State s, Map<State, Integer> idMap) {
        Integer id = idMap.get(s);
        if (id != null) {
            return id;
        }
        id = idMap.size();
        idMap.put(s, id);
        return id;
    }

    private <S> Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Record current;
        int thisStates = this.register.size();
        HashMap<State, Integer> stateIds = new HashMap<State, Integer>();
        if (this.sink != null) {
            stateIds.put(this.sink, 0);
            ++thisStates;
        }
        int targetStates = target.size();
        if (!omitUndefined) {
            ++targetStates;
        }
        UnionFind uf = new UnionFind(thisStates + targetStates);
        State init1 = this.init;
        Object init2 = target.getInitialState();
        if (init2 == null && omitUndefined) {
            return null;
        }
        boolean acc = target.isAccepting(init2);
        if (init1.getAcceptance().conflicts(acc)) {
            return Word.epsilon();
        }
        StateIDs tgtIds = target.stateIDs();
        int id1 = AbstractIncrementalDFADAGBuilder.getStateId(init1, stateIds);
        int id2 = (init2 != null ? tgtIds.getStateId(init2) : targetStates - 1) + thisStates;
        uf.link(id1, id2);
        ArrayDeque<Record<Object, I>> queue = new ArrayDeque<Record<Object, I>>();
        queue.add(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            State state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                State succ1;
                Object succ2;
                Object object = succ2 = state2 != null ? target.getSuccessor(state2, sym) : null;
                if (succ2 == null && omitUndefined) continue;
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                State state = succ1 = state1 != this.sink ? state1.getSuccessor(idx) : this.sink;
                if (succ1 == null) continue;
                id1 = AbstractIncrementalDFADAGBuilder.getStateId(succ1, stateIds);
                id2 = (succ2 != null ? tgtIds.getStateId(succ2) : targetStates - 1) + thisStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                if (succ1 == this.sink) {
                    if (succ2 == null) continue;
                    if (target.isAccepting(succ2)) {
                        lastSym = sym;
                        break block0;
                    }
                } else {
                    boolean succ2acc;
                    boolean bl = succ2acc = succ2 != null ? target.isAccepting(succ2) : false;
                    if (succ1.getAcceptance().conflicts(succ2acc)) {
                        lastSym = sym;
                        break block0;
                    }
                }
                uf.link(r1, r2);
                queue.add(new Record<Object, I>(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            wb.setSymbol(--index, current.reachedVia);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    protected abstract State getState(Word<? extends I> var1);

    protected State replaceOrRegister(StateSignature sig) {
        State state = this.register.get(sig);
        if (state != null) {
            return state;
        }
        state = new State(sig);
        this.register.put(sig, state);
        for (int i = 0; i < sig.successors.length; ++i) {
            State succ = sig.successors[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return state;
    }

    protected State replaceOrRegister(State state) {
        StateSignature sig = state.getSignature();
        State other = this.register.get(sig);
        if (other != null) {
            if (state != other) {
                for (int i = 0; i < sig.successors.length; ++i) {
                    State succ = sig.successors[i];
                    if (succ == null) continue;
                    succ.decreaseIncoming();
                }
            }
            return other;
        }
        this.register.put(sig, state);
        return state;
    }

    protected void updateInitSignature(Acceptance acc) {
        StateSignature sig = this.init.getSignature();
        sig.acceptance = acc;
    }

    protected State updateSignature(State state, Acceptance acc) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected void updateInitSignature(int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = sig.successors[idx];
        if (oldSucc == succ) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
    }

    protected void updateInitSignature(Acceptance acc, int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = sig.successors[idx];
        Acceptance oldAcc = sig.acceptance;
        if (oldSucc == succ && oldAcc == acc) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
        sig.acceptance = acc;
    }

    protected State updateSignature(State state, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (sig.successors[idx] == succ) {
            return state;
        }
        this.register.remove(sig);
        if (sig.successors[idx] != null) {
            sig.successors[idx].decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected State updateSignature(State state, Acceptance acc, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (sig.successors[idx] == succ && sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        sig.successors[idx] = succ;
        sig.acceptance = acc;
        return this.replaceOrRegister(state);
    }

    protected State clone(State other, Acceptance acc) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (sig.acceptance == acc) {
            return other;
        }
        sig = sig.duplicate();
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    protected State hiddenClone(State other) {
        assert (other != this.init);
        StateSignature sig = other.getSignature().duplicate();
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = sig.successors[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return new State(sig);
    }

    protected void hide(State state) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        this.register.remove(sig);
    }

    protected State unhide(State state, Acceptance acc, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        sig.acceptance = acc;
        State prevSucc = sig.successors[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected State unhide(State state, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        State prevSucc = sig.successors[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected State clone(State other, int idx, State succ) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (sig.successors[idx] == succ) {
            return other;
        }
        sig = sig.duplicate();
        sig.successors[idx] = succ;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    protected State clone(State other, Acceptance acc, int idx, State succ) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (sig.successors[idx] == succ && sig.acceptance == acc) {
            return other;
        }
        sig = sig.duplicate();
        sig.successors[idx] = succ;
        sig.acceptance = acc;
        return this.replaceOrRegister(sig);
    }

    @Override
    public GraphView asGraph() {
        return new GraphView();
    }

    public TransitionSystemView asTransitionSystem() {
        return new TransitionSystemView();
    }

    private static final class Record<S, I> {
        public final State state1;
        public final S state2;
        public final I reachedVia;
        public final Record<S, I> reachedFrom;
        public final int depth;

        public Record(State state1, S state2) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = null;
            this.reachedFrom = null;
            this.depth = 0;
        }

        public Record(State state1, S state2, I reachedVia, Record<S, I> reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = reachedVia;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom.depth + 1;
        }
    }

    public class TransitionSystemView
    extends AbstractIncrementalDFABuilder.AbstractTransitionSystemView<State, I, State> {
        public State getSuccessor(State transition) {
            return transition;
        }

        public State getTransition(State state, I input) {
            if (state == AbstractIncrementalDFADAGBuilder.this.sink) {
                return state;
            }
            int idx = AbstractIncrementalDFADAGBuilder.this.inputAlphabet.getSymbolIndex(input);
            return state.getSuccessor(idx);
        }

        public State getInitialState() {
            return AbstractIncrementalDFADAGBuilder.this.init;
        }

        @Override
        @Nonnull
        public Acceptance getAcceptance(State state) {
            return state.getAcceptance();
        }
    }

    @ParametersAreNonnullByDefault
    public class GraphView
    extends AbstractIncrementalDFABuilder.AbstractGraphView<I, State, EdgeRecord> {
        public Collection<State> getNodes() {
            if (AbstractIncrementalDFADAGBuilder.this.sink == null) {
                return Collections.unmodifiableCollection(AbstractIncrementalDFADAGBuilder.this.register.values());
            }
            ArrayList<State> result = new ArrayList<State>(AbstractIncrementalDFADAGBuilder.this.register.size() + 1);
            result.addAll(AbstractIncrementalDFADAGBuilder.this.register.values());
            result.add(AbstractIncrementalDFADAGBuilder.this.sink);
            return result;
        }

        public int size() {
            return AbstractIncrementalDFADAGBuilder.this.register.size() + (AbstractIncrementalDFADAGBuilder.this.sink == null ? 0 : 1);
        }

        public Collection<EdgeRecord> getOutgoingEdges(State node) {
            if (node.isSink()) {
                return Collections.emptySet();
            }
            StateSignature sig = node.getSignature();
            ArrayList<EdgeRecord> result = new ArrayList<EdgeRecord>();
            for (int i = 0; i < AbstractIncrementalDFADAGBuilder.this.alphabetSize; ++i) {
                if (sig.successors[i] == null) continue;
                result.add(new EdgeRecord(node, i));
            }
            return result;
        }

        @Nonnull
        public State getTarget(EdgeRecord edge) {
            int idx = edge.transIdx;
            return edge.source.getSuccessor(idx);
        }

        @Override
        @Nonnull
        public Acceptance getAcceptance(State node) {
            return node.getAcceptance();
        }

        @Override
        @Nullable
        public I getInputSymbol(EdgeRecord edge) {
            return AbstractIncrementalDFADAGBuilder.this.inputAlphabet.getSymbol(edge.transIdx);
        }

        @Override
        @Nonnull
        public GraphDOTHelper<State, EdgeRecord> getGraphDOTHelper() {
            return new DelegateDOTHelper<State, EdgeRecord>(super.getGraphDOTHelper()){
                private int id;
                {
                    this.id = 0;
                }

                public boolean getNodeProperties(State node, Map<String, String> properties) {
                    if (!super.getNodeProperties((Object)node, properties)) {
                        return false;
                    }
                    properties.put("label", "n" + this.id++);
                    if (node.isConfluence()) {
                        String shape = node.getAcceptance() == Acceptance.TRUE ? "doubleoctagon" : "octagon";
                        properties.put("shape", shape);
                    }
                    return true;
                }
            };
        }

        @Override
        @Nonnull
        public State getInitialNode() {
            return AbstractIncrementalDFADAGBuilder.this.init;
        }
    }
}

