/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractIncrementalDFABuilder<I>
implements IncrementalDFABuilder<I> {
    protected final Alphabet<I> inputAlphabet;
    protected final int alphabetSize;

    public AbstractIncrementalDFABuilder(@Nonnull Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        return this.lookup(word) != Acceptance.DONT_KNOW;
    }

    @Override
    public void insert(Word<? extends I> word) throws ConflictException {
        this.insert(word, true);
    }

    protected static abstract class AbstractTransitionSystemView<S, I, T>
    implements IncrementalDFABuilder.TransitionSystemView<S, I, T> {
        protected AbstractTransitionSystemView() {
        }

        public Acceptance getStateProperty(S state) {
            return this.getAcceptance(state);
        }

        public Void getTransitionProperty(T transition) {
            return null;
        }
    }

    protected static abstract class AbstractGraphView<I, N, E>
    implements IncrementalDFABuilder.GraphView<I, N, E> {
        protected AbstractGraphView() {
        }

        public GraphDOTHelper<N, E> getGraphDOTHelper() {
            return new DefaultDOTHelper<N, E>(){

                public Collection<? extends N> initialNodes() {
                    return Collections.singleton(this.getInitialNode());
                }

                public boolean getNodeProperties(N node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    switch (this.getAcceptance(node)) {
                        case TRUE: {
                            properties.put("shape", "doublecircle");
                            break;
                        }
                        case DONT_KNOW: {
                            properties.put("style", "dashed");
                            break;
                        }
                    }
                    return true;
                }

                public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    Object input = this.getInputSymbol(edge);
                    properties.put("label", String.valueOf(input));
                    return true;
                }
            };
        }
    }
}

