/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import java.util.Arrays;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.State;

final class StateSignature {
    public final State[] successors;
    public Acceptance acceptance;
    private int hashCode;

    public StateSignature(int numSuccs, Acceptance acceptance) {
        this.successors = new State[numSuccs];
        this.acceptance = acceptance;
        this.updateHashCode();
    }

    public StateSignature(StateSignature other) {
        this.successors = (State[])other.successors.clone();
        this.acceptance = other.acceptance;
    }

    public StateSignature clone() {
        return new StateSignature(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void updateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.acceptance.hashCode();
        this.hashCode = result = 31 * result + Arrays.hashCode(this.successors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != StateSignature.class) {
            return false;
        }
        StateSignature other = (StateSignature)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.acceptance != other.acceptance) {
            return false;
        }
        for (int i = 0; i < this.successors.length; ++i) {
            if (this.successors[i] == other.successors[i]) continue;
            return false;
        }
        return true;
    }
}

