/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.abstractimpl.AbstractDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.commons.util.UnionFind;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.DOTPlottableGraph;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.IncrementalConstruction;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.DOTHelper;
import net.automatalib.incremental.dfa.EdgeRecord;
import net.automatalib.incremental.dfa.State;
import net.automatalib.incremental.dfa.StateSignature;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public abstract class AbstractIncrementalDFABuilder<I>
extends AbstractDeterministicAutomaton<State, I, State>
implements UniversalGraph<State, EdgeRecord, Acceptance, I>,
DOTPlottableGraph<State, EdgeRecord>,
IncrementalConstruction<DFA<?, I>, I> {
    protected final Map<StateSignature, State> register = new HashMap<StateSignature, State>();
    protected final Alphabet<I> inputAlphabet;
    protected final int alphabetSize;
    protected final State init;
    protected State sink;

    public AbstractIncrementalDFABuilder(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
        StateSignature sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
        this.init = new State(sig);
        this.register.put(null, this.init);
    }

    public abstract Acceptance lookup(Word<I> var1);

    public abstract void insert(Word<I> var1, boolean var2) throws ConflictException;

    public final void insert(Word<I> word) throws ConflictException {
        this.insert(word, true);
    }

    public int size() {
        return this.register.size() + (this.sink != null ? 1 : 0);
    }

    public Collection<State> getNodes() {
        if (this.sink == null) {
            return Collections.unmodifiableCollection(this.register.values());
        }
        ArrayList<State> result = new ArrayList<State>(this.register.size() + 1);
        result.addAll(this.register.values());
        result.add(this.sink);
        return result;
    }

    public Collection<EdgeRecord> getOutgoingEdges(State node) {
        ArrayList<EdgeRecord> edges = new ArrayList<EdgeRecord>();
        for (int i = 0; i < this.alphabetSize; ++i) {
            if ((this.sink == null || node != this.sink) && node.getSuccessor(i) == null) continue;
            edges.add(new EdgeRecord(node, i));
        }
        return edges;
    }

    public State getTarget(EdgeRecord edge) {
        if (this.sink != null && edge.source == this.sink) {
            return edge.source;
        }
        return edge.source.getSuccessor(edge.transIdx);
    }

    public Acceptance getNodeProperty(State node) {
        if (this.sink != null && node == this.sink) {
            return Acceptance.FALSE;
        }
        return node.getAcceptance();
    }

    public I getEdgeProperty(EdgeRecord edge) {
        return (I)this.inputAlphabet.getSymbol(edge.transIdx);
    }

    public State getTransition(State state, I input) {
        if (this.sink != null && state == this.sink) {
            return this.sink;
        }
        int idx = this.inputAlphabet.getSymbolIndex(input);
        return state.getSuccessor(idx);
    }

    public State getSuccessor(State transition) {
        return transition;
    }

    public State getInitialState() {
        return this.init;
    }

    public Collection<State> getStates() {
        return this.getNodes();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public Word<I> findSeparatingWord(DFA<?, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    @Override
    public DFA<?, I> toAutomaton() {
        CompactDFA result = new CompactDFA(this.inputAlphabet, this.register.size() + (this.sink != null ? 1 : 0));
        HashMap<State, Integer> stateMap = new HashMap<State, Integer>();
        for (State state : this.register.values()) {
            boolean acc = state.getAcceptance() == Acceptance.TRUE;
            Integer id = state == this.init ? result.addInitialState(acc) : result.addState(acc);
            stateMap.put(state, id);
        }
        if (this.sink != null) {
            stateMap.put(this.sink, result.addState(false));
        }
        for (Map.Entry entry : stateMap.entrySet()) {
            State s = (State)entry.getKey();
            Integer srcId = (Integer)entry.getValue();
            for (int i = 0; i < this.inputAlphabet.size(); ++i) {
                State succ;
                if (s == this.sink) {
                    succ = this.sink;
                } else {
                    succ = s.getSuccessor(i);
                    if (succ == null) continue;
                }
                Object sym = this.inputAlphabet.getSymbol(i);
                Integer succId = (Integer)stateMap.get(succ);
                result.addTransition((Object)srcId, sym, (Object)succId);
            }
        }
        return result;
    }

    @Override
    public boolean hasDefinitiveInformation(Word<I> word) {
        State s = this.getState(word);
        if (s == null) {
            return false;
        }
        if (s == this.sink) {
            return true;
        }
        return s.getAcceptance() != Acceptance.DONT_KNOW;
    }

    public GraphDOTHelper<State, EdgeRecord> getGraphDOTHelper() {
        return new DOTHelper(this.inputAlphabet, this.init);
    }

    public NodeIDs<State> nodeIDs() {
        return AbstractAutomatonGraph.nodeIDs((Automaton)this);
    }

    public <T> MutableMapping<State, T> createStaticNodeMapping() {
        return AbstractAutomatonGraph.createStaticNodeMapping((Automaton)this);
    }

    public <T> MutableMapping<State, T> createDynamicNodeMapping() {
        return AbstractAutomatonGraph.createDynamicNodeMapping((Automaton)this);
    }

    private static int getStateId(State s, Map<State, Integer> idMap) {
        Integer id = idMap.get(s);
        if (id != null) {
            return id;
        }
        id = idMap.size();
        idMap.put(s, id);
        return id;
    }

    private <S> Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Record current;
        int thisStates = this.register.size();
        HashMap<State, Integer> stateIds = new HashMap<State, Integer>();
        if (this.sink != null) {
            stateIds.put(this.sink, 0);
            ++thisStates;
        }
        int targetStates = target.size();
        if (!omitUndefined) {
            ++targetStates;
        }
        UnionFind uf = new UnionFind(thisStates + targetStates);
        State init1 = this.init;
        Object init2 = target.getInitialState();
        if (init2 == null && omitUndefined) {
            return null;
        }
        boolean acc = target.isAccepting(init2);
        if (init1.getAcceptance().conflicts(acc)) {
            return Word.epsilon();
        }
        StateIDs tgtIds = target.stateIDs();
        int id1 = AbstractIncrementalDFABuilder.getStateId(init1, stateIds);
        int id2 = (init2 != null ? tgtIds.getStateId(init2) : targetStates - 1) + thisStates;
        uf.link(id1, id2);
        ArrayDeque<Record<Object, I>> queue = new ArrayDeque<Record<Object, I>>();
        queue.offer(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            State state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                State succ1;
                Object succ2;
                Object object = succ2 = state2 != null ? target.getSuccessor(state2, sym) : null;
                if (succ2 == null && omitUndefined) continue;
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                State state = succ1 = state1 != this.sink ? state1.getSuccessor(idx) : this.sink;
                if (succ1 == null) continue;
                id1 = AbstractIncrementalDFABuilder.getStateId(succ1, stateIds);
                id2 = (succ2 != null ? tgtIds.getStateId(succ2) : targetStates - 1) + thisStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                if (succ1 == this.sink) {
                    if (succ2 == null) continue;
                    if (target.isAccepting(succ2)) {
                        lastSym = sym;
                        break block0;
                    }
                } else {
                    boolean succ2acc;
                    boolean bl = succ2acc = succ2 != null ? target.isAccepting(succ2) : false;
                    if (succ1.getAcceptance().conflicts(succ2acc)) {
                        lastSym = sym;
                        break block0;
                    }
                }
                uf.link(r1, r2);
                queue.offer(new Record<Object, I>(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            wb.setSymbol(--index, current.reachedVia);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    protected abstract State getState(Word<I> var1);

    protected State replaceOrRegister(StateSignature sig) {
        State state = this.register.get(sig);
        if (state != null) {
            return state;
        }
        state = new State(sig);
        this.register.put(sig, state);
        for (int i = 0; i < sig.successors.length; ++i) {
            State succ = sig.successors[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return state;
    }

    protected State replaceOrRegister(State state) {
        StateSignature sig = state.getSignature();
        State other = this.register.get(sig);
        if (other != null) {
            if (state != other) {
                for (int i = 0; i < sig.successors.length; ++i) {
                    State succ = sig.successors[i];
                    if (succ == null) continue;
                    succ.decreaseIncoming();
                }
            }
            return other;
        }
        this.register.put(sig, state);
        return state;
    }

    protected void updateInitSignature(Acceptance acc) {
        StateSignature sig = this.init.getSignature();
        sig.acceptance = acc;
    }

    protected State updateSignature(State state, Acceptance acc) {
        StateSignature sig = state.getSignature();
        if (sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected void updateInitSignature(int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = sig.successors[idx];
        if (oldSucc == succ) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
    }

    protected State updateSignature(State state, int idx, State succ) {
        StateSignature sig = state.getSignature();
        if (sig.successors[idx] == succ) {
            return state;
        }
        this.register.remove(sig);
        if (sig.successors[idx] != null) {
            sig.successors[idx].decreaseIncoming();
        }
        sig.successors[idx] = succ;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    protected State updateSignature(State state, Acceptance acc, int idx, State succ) {
        StateSignature sig = state.getSignature();
        if (sig.successors[idx] == succ && sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        sig.successors[idx] = succ;
        sig.acceptance = acc;
        return this.replaceOrRegister(state);
    }

    protected State clone(State other, Acceptance acc) {
        StateSignature sig = other.getSignature();
        if (sig.acceptance == acc) {
            return other;
        }
        sig = sig.clone();
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    protected State clone(State other, int idx, State succ) {
        StateSignature sig = other.getSignature();
        if (sig.successors[idx] == succ) {
            return other;
        }
        sig = sig.clone();
        sig.successors[idx] = succ;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    protected State clone(State other, Acceptance acc, int idx, State succ) {
        StateSignature sig = other.getSignature();
        if (sig.successors[idx] == succ && sig.acceptance == acc) {
            return other;
        }
        sig = sig.clone();
        sig.successors[idx] = succ;
        sig.acceptance = acc;
        return this.replaceOrRegister(sig);
    }

    private static final class Record<S, I> {
        public final State state1;
        public final S state2;
        public final I reachedVia;
        public final Record<S, I> reachedFrom;
        public final int depth;

        public Record(State state1, S state2) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = null;
            this.reachedFrom = null;
            this.depth = 0;
        }

        public Record(State state1, S state2, I reachedVia, Record<S, I> reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = reachedVia;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom.depth + 1;
        }
    }
}

