/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.incremental.mealy.State;
import net.automatalib.incremental.mealy.TransitionRecord;
import net.automatalib.words.Alphabet;

final class DOTHelper
extends DefaultDOTHelper<State, TransitionRecord> {
    private final State initial;
    private final Alphabet<?> inputAlphabet;
    private int id = 0;

    public DOTHelper(Alphabet<?> inputAlphabet, State initial) {
        this.inputAlphabet = inputAlphabet;
        this.initial = initial;
    }

    protected Collection<? extends State> initialNodes() {
        return Collections.singleton(this.initial);
    }

    public boolean getNodeProperties(State node, Map<String, String> properties) {
        if (!super.getNodeProperties((Object)node, properties)) {
            return false;
        }
        String shape = node.isConfluence() ? "octagon" : "circle";
        properties.put("shape", shape);
        properties.put("label", "s" + this.id++);
        return true;
    }

    public boolean getEdgeProperties(State src, TransitionRecord edge, State tgt, Map<String, String> properties) {
        if (!super.getEdgeProperties((Object)src, (Object)edge, (Object)tgt, properties)) {
            return false;
        }
        Object in = this.inputAlphabet.getSymbol(edge.transIdx);
        Object out = edge.source.getOutput(edge.transIdx);
        properties.put("label", String.valueOf(in) + " / " + String.valueOf(out));
        return true;
    }
}

