/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.StateSignature;

final class State {
    private int numIncoming;
    private final StateSignature signature;

    public State(StateSignature signature) {
        this.signature = signature;
        this.numIncoming = 0;
    }

    public void increaseIncoming() {
        ++this.numIncoming;
    }

    public void decreaseIncoming() {
        --this.numIncoming;
    }

    public boolean isConfluence() {
        return this.numIncoming > 1;
    }

    public Acceptance getAcceptance() {
        return this.signature.acceptance;
    }

    public State getSuccessor(int idx) {
        return this.signature.successors[idx];
    }

    public StateSignature getSignature() {
        return this.signature;
    }

    public boolean isSink() {
        return this.signature == null;
    }

    public String toString() {
        if (this.isSink()) {
            return "sink";
        }
        return "s";
    }
}

