/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.visualization.dot.DOT;

final class PlottedGraph {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private String name;
    private String dotText;
    private BufferedImage image;

    PlottedGraph(String name, Reader dotText) throws IOException {
        int len;
        this.name = name;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = dotText.read(buf)) != -1) {
            sb.append(buf, 0, len);
        }
        IOUtil.closeQuietly((Closeable)dotText);
        this.updateDOTText(sb.toString());
    }

    public boolean updateDOTText(String dotText) {
        try (InputStream pngIs = DOT.runDOT(dotText, "png", new String[0]);){
            this.image = ImageIO.read(pngIs);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Failed to invoke the DOT command!", "Failure rendering graph", 0);
            return false;
        }
        this.dotText = dotText;
        return true;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public String getDOTText() {
        return this.dotText;
    }

    public void saveDot(File file) throws IOException {
        try (BufferedWriter w = new BufferedWriter(IOUtil.asUTF8Writer((File)file));){
            w.write(this.dotText);
        }
    }

    public void savePng(File file) throws IOException {
        ImageIO.write((RenderedImage)this.image, "png", file);
    }
}

