/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.visualization.dot.DOT;
import net.automatalib.visualization.dot.DOTMisc;
import net.automatalib.visualization.dot.ImageComponent;

public class DOTComponent
extends ImageComponent {
    private static final long serialVersionUID = 1L;
    private String dot;
    private final Action saveDotAction = new AbstractAction("Save DOT"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser saveDlg = new JFileChooser();
            saveDlg.setFileFilter(DOTMisc.DOT_FILTER);
            int result = saveDlg.showSaveDialog(DOTComponent.this);
            if (result != 0) {
                return;
            }
            try (BufferedWriter w = new BufferedWriter(IOUtil.asUTF8Writer((File)saveDlg.getSelectedFile()));){
                w.write(DOTComponent.this.dot);
                ((Writer)w).close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(DOTComponent.this, "Could not save DOT file: " + ex.getMessage(), "Cannot save DOT", 0);
            }
        }
    };

    public DOTComponent() {
    }

    public DOTComponent(Reader dotReader) throws IOException {
        this.renderDot(dotReader);
    }

    private void renderDot(Reader dotReader) throws IOException {
        StringWriter w = new StringWriter();
        IOUtil.copy((Reader)dotReader, (Writer)w);
        String dot = w.getBuffer().toString();
        BufferedImage img = DOT.renderDOTImage(dot);
        super.setImage(img);
        this.dot = dot;
    }

    @Override
    public void listActions(List<Action> actions) {
        super.listActions(actions);
        actions.add(this.saveDotAction);
    }

    public String getDot() {
        return this.dot;
    }

    public Action getSaveDotAction() {
        return this.saveDotAction;
    }
}

