/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.automatalib.AutomataLibSettings;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.visualization.dot.DOTComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DOT {
    private static final Logger LOGGER;
    private static final int MAX_WIDTH = 800;
    private static final int MAX_HEIGHT = 600;
    private static String dotExe;

    private DOT() {
    }

    public static void setDotExe(String dotExe) {
        DOT.dotExe = dotExe;
    }

    public static boolean checkUsable() {
        try {
            Process p = DOT.executeDOTRaw("-V");
            int result = p.waitFor();
            if (result == 0) {
                return true;
            }
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.error("Error executing dot", (Throwable)ex);
        }
        return false;
    }

    public static Process executeDOTRaw(String ... opts) throws IOException {
        String[] dotArgs = new String[1 + opts.length];
        dotArgs[0] = dotExe;
        System.arraycopy(opts, 0, dotArgs, 1, opts.length);
        return Runtime.getRuntime().exec(dotArgs);
    }

    public static Process executeDOT(String format, String ... additionalOpts) throws IOException {
        String[] dotArgs = new String[1 + additionalOpts.length];
        dotArgs[0] = "-T" + format;
        System.arraycopy(additionalOpts, 0, dotArgs, 1, additionalOpts.length);
        return DOT.executeDOTRaw(dotArgs);
    }

    public static InputStream runDOT(String dotText, String format, String ... additionalOpts) throws IOException {
        StringReader sr = new StringReader(dotText);
        return DOT.runDOT((Reader)sr, format, additionalOpts);
    }

    public static InputStream runDOT(Reader r, String format, String ... additionalOpts) throws IOException {
        Process dot = DOT.executeDOT(format, additionalOpts);
        OutputStream dotIn = dot.getOutputStream();
        OutputStreamWriter dotWriter = new OutputStreamWriter(dotIn, StandardCharsets.UTF_8);
        IOUtil.copy((Reader)r, (Writer)dotWriter);
        try {
            IOUtil.skip((InputStream)dot.getErrorStream());
        }
        catch (IOException e) {
            LOGGER.error("Could not skip over error stream", (Throwable)e);
        }
        return dot.getInputStream();
    }

    public static InputStream runDOT(File dotFile, String format, String ... additionalOpts) throws IOException {
        return DOT.runDOT(IOUtil.asUTF8Reader((File)dotFile), format, additionalOpts);
    }

    public static void runDOT(String dotText, String format, File out) throws IOException {
        DOT.runDOT((Reader)new StringReader(dotText), format, out);
    }

    public static void runDOT(Reader r, String format, File out) throws IOException {
        Process dot = DOT.executeDOT(format, "-o" + out.getAbsolutePath());
        OutputStream dotIn = dot.getOutputStream();
        OutputStreamWriter dotWriter = new OutputStreamWriter(dotIn, StandardCharsets.UTF_8);
        IOUtil.copy((Reader)r, (Writer)dotWriter);
        dot.getErrorStream().close();
        dot.getInputStream().close();
        try {
            dot.waitFor();
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Interrupted while waiting for 'dot' process to exit.", (Throwable)ex);
        }
    }

    public static void runDOT(File dotFile, String format, File out) throws IOException {
        DOT.runDOT(IOUtil.asUTF8Reader((File)dotFile), format, out);
    }

    public static void renderDOTExternal(String dotText, String format) {
        DOT.renderDOTExternal(new StringReader(dotText), format);
    }

    public static void renderDOTExternal(Reader r, String format) {
        try {
            File image = File.createTempFile("dot", format);
            DOT.runDOT(r, format, image);
            Desktop.getDesktop().open(image);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error rendering DOT: " + e.getMessage(), "Error", 0);
        }
    }

    public static void renderDOTExternal(File dotFile, String format) throws FileNotFoundException {
        DOT.renderDOTExternal(IOUtil.asUTF8Reader((File)dotFile), format);
    }

    public static void renderDOT(File dotFile, boolean modal) throws FileNotFoundException {
        DOT.renderDOT(IOUtil.asUTF8Reader((File)dotFile), modal);
    }

    public static void renderDOT(Reader r, boolean modal) {
        DOTComponent cmp = DOT.createDOTComponent(r);
        if (cmp == null) {
            return;
        }
        final JDialog frame = new JDialog((Dialog)null, modal);
        JScrollPane scrollPane = new JScrollPane(cmp);
        frame.setContentPane(scrollPane);
        frame.setMaximumSize(new Dimension(800, 600));
        frame.pack();
        JMenu menu = new JMenu("File");
        menu.add(cmp.getSavePngAction());
        menu.add(cmp.getSaveDotAction());
        menu.addSeparator();
        menu.add(new AbstractAction("Close"){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    frame.dispatchEvent(new WindowEvent(frame, 201));
                }
            }
        });
    }

    public static void renderDOT(String dotText, boolean modal) {
        DOT.renderDOT(new StringReader(dotText), modal);
    }

    public static DOTComponent createDOTComponent(Reader r) {
        try {
            return new DOTComponent(r);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not run DOT: " + e.getMessage(), "Failed to run DOT", 0);
            return null;
        }
    }

    public static BufferedImage renderDOTImage(String dotText) throws IOException {
        return DOT.renderDOTImage(new StringReader(dotText));
    }

    public static BufferedImage renderDOTImage(Reader dotReader) throws IOException {
        InputStream pngIs = DOT.runDOT(dotReader, "png", new String[0]);
        BufferedImage img = ImageIO.read(pngIs);
        pngIs.close();
        return img;
    }

    public static BufferedImage renderDOTImage(File dotFile) throws IOException {
        return DOT.renderDOTImage(new BufferedReader(IOUtil.asUTF8Reader((File)dotFile)));
    }

    public static Writer createDotWriter(final boolean modal) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                DOT.renderDOT(this.getBuffer().toString(), modal);
                super.close();
            }
        };
    }

    static {
        String dotExeName;
        LOGGER = LoggerFactory.getLogger(DOT.class);
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String dotExePath = settings.getProperty("dot.exe.dir");
        String dotExe = dotExeName = settings.getProperty("dot.exe.name", "dot");
        if (dotExePath != null) {
            Path dotBasePath = FileSystems.getDefault().getPath(dotExePath, new String[0]);
            Path resolvedDotPath = dotBasePath.resolve(dotExeName);
            dotExe = resolvedDotPath.toString();
        }
        DOT.dotExe = dotExe;
    }
}

