/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.automatalib.common.util.Pair;
import net.automatalib.visualization.dot.DOTImageComponent;
import net.automatalib.visualization.dot.DOTUtil;
import net.automatalib.visualization.dot.PlottedGraph;

final class DOTMultiDialog<I>
extends JDialog {
    DOTMultiDialog(List<Pair<String, I>> dots, boolean modal, ThrowableExtractor<I, String> extractor) throws IOException {
        super((Dialog)null, modal);
        DefaultListModel<PlottedGraph> graphs = new DefaultListModel<PlottedGraph>();
        DOTImageComponent cmp = new DOTImageComponent();
        JList listBox = new JList(graphs);
        Action saveDotAction = cmp.getSaveDotAction();
        Action savePngAction = cmp.getSavePngAction();
        for (Pair<String, I> d : dots) {
            PlottedGraph pg = new PlottedGraph((String)d.getFirst(), extractor.extract(d.getSecond()));
            graphs.addElement(pg);
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(cmp);
        mainPanel.add((Component)scrollPane, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridheight = 1;
        listBox.setSelectionMode(0);
        listBox.addListSelectionListener(e -> {
            PlottedGraph pg = (PlottedGraph)listBox.getSelectedValue();
            if (pg == null) {
                cmp.setData(null);
                saveDotAction.setEnabled(false);
                savePngAction.setEnabled(false);
            } else {
                cmp.setData(pg);
                saveDotAction.setEnabled(true);
                savePngAction.setEnabled(true);
            }
            scrollPane.validate();
        });
        mainPanel.add(listBox, c);
        if (graphs.isEmpty()) {
            cmp.setData(null);
            saveDotAction.setEnabled(false);
            savePngAction.setEnabled(false);
        } else {
            listBox.setSelectedIndex(0);
        }
        JMenu menu = new JMenu("File");
        menu.add(cmp.getSaveDotAction());
        menu.add(cmp.getSavePngAction());
        menu.addSeparator();
        menu.add(DOTUtil.getCloseAction(this));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(menu);
        this.setContentPane(mainPanel);
        this.setJMenuBar(jMenuBar);
        this.setPreferredSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.addKeyListener(DOTUtil.closeOnEscapeAdapter(this));
        this.pack();
        this.setVisible(true);
    }

    static interface ThrowableExtractor<I, O> {
        public O extract(I var1) throws IOException;
    }
}

