/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import net.automatalib.visualization.dot.DOTImageComponent;
import net.automatalib.visualization.dot.DOTUtil;
import net.automatalib.visualization.dot.PlottedGraph;

final class DOTDialog
extends JDialog {
    DOTDialog(String dot, boolean modal) throws IOException {
        super((Dialog)null, modal);
        PlottedGraph pg = new PlottedGraph("Graph", dot);
        DOTImageComponent cmp = new DOTImageComponent();
        cmp.setData(pg);
        JScrollPane scrollPane = new JScrollPane(cmp);
        JMenu menu = new JMenu("File");
        menu.add(cmp.getSavePngAction());
        menu.add(cmp.getSaveDotAction());
        menu.addSeparator();
        menu.add(DOTUtil.getCloseAction(this));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        this.setContentPane(scrollPane);
        this.setJMenuBar(menuBar);
        this.setPreferredSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.addKeyListener(DOTUtil.closeOnEscapeAdapter(this));
        this.pack();
        this.setVisible(true);
    }
}

