/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.words.Alphabet;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.abstractimpl.AbstractAlphabet;
import net.automatalib.words.abstractimpl.AbstractVPDAlphabet;
import net.automatalib.words.impl.VPDSym;

public class GrowingVPDAlphabet<I>
extends AbstractVPDAlphabet<VPDSym<I>>
implements VPDAlphabet<VPDSym<I>> {
    private final List<VPDSym<I>> allSyms;
    private final List<VPDSym<I>> callSyms;
    private final List<VPDSym<I>> internalSyms;
    private final List<VPDSym<I>> returnSyms;

    public GrowingVPDAlphabet() {
        this(new ArrayList<VPDSym<I>>(), new ArrayList<VPDSym<I>>(), new ArrayList<VPDSym<I>>());
    }

    private GrowingVPDAlphabet(List<VPDSym<I>> internalSyms, List<VPDSym<I>> callSyms, List<VPDSym<I>> returnSyms) {
        super(new AlphabetView<I>(internalSyms), new AlphabetView<I>(callSyms), new AlphabetView<I>(returnSyms));
        this.internalSyms = internalSyms;
        this.callSyms = callSyms;
        this.returnSyms = returnSyms;
        this.allSyms = new ArrayList<VPDSym<I>>();
    }

    public VPDSym<I> addNewSymbol(I userObject, VPDAlphabet.SymbolType type) {
        List<VPDSym<I>> localList;
        switch (type) {
            case CALL: {
                localList = this.callSyms;
                break;
            }
            case RETURN: {
                localList = this.returnSyms;
                break;
            }
            default: {
                localList = this.internalSyms;
            }
        }
        VPDSym<I> vpdSym = new VPDSym<I>(userObject, type, localList.size(), this.allSyms.size());
        this.allSyms.add(vpdSym);
        localList.add(vpdSym);
        return vpdSym;
    }

    @Override
    public VPDAlphabet.SymbolType getSymbolType(VPDSym<I> symbol) {
        return symbol.getType();
    }

    @Override
    public int size() {
        return this.allSyms.size();
    }

    @Override
    public VPDSym<I> getSymbol(int index) {
        return this.allSyms.get(index);
    }

    @Override
    public int getSymbolIndex(VPDSym<I> symbol) {
        if (!this.containsSymbol(symbol)) {
            throw new IllegalArgumentException();
        }
        return symbol.getGlobalIndex();
    }

    @Override
    public boolean containsSymbol(VPDSym<I> symbol) {
        int idx = symbol.getGlobalIndex();
        return idx < this.allSyms.size() && this.allSyms.get(idx) == symbol;
    }

    private static class AlphabetView<I>
    extends AbstractAlphabet<VPDSym<I>>
    implements Alphabet<VPDSym<I>> {
        private final List<VPDSym<I>> list;

        AlphabetView(List<VPDSym<I>> list) {
            this.list = list;
        }

        public VPDSym<I> getSymbol(int index) {
            return this.list.get(index);
        }

        public int getSymbolIndex(VPDSym<I> symbol) {
            if (!this.containsSymbol(symbol)) {
                throw new IllegalArgumentException();
            }
            return symbol.getLocalIndex();
        }

        public boolean containsSymbol(VPDSym<I> symbol) {
            int idx = symbol.getLocalIndex();
            return idx < this.list.size() && this.list.get(idx) == symbol;
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

