/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.abstractimpl;

import java.util.Collection;
import java.util.HashSet;
import net.automatalib.words.Alphabet;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public abstract class AbstractVPDAlphabet<I>
extends AbstractAlphabet<I>
implements VPDAlphabet<I> {
    private final Alphabet<I> internalAlphabet;
    private final Alphabet<I> callAlphabet;
    private final Alphabet<I> returnAlphabet;

    public AbstractVPDAlphabet(Alphabet<I> internalAlphabet, Alphabet<I> callAlphabet, Alphabet<I> returnAlphabet) {
        AbstractVPDAlphabet.validateDisjointness(internalAlphabet, VPDAlphabet.SymbolType.INTERNAL, new Collection[]{callAlphabet, returnAlphabet});
        AbstractVPDAlphabet.validateDisjointness(callAlphabet, VPDAlphabet.SymbolType.CALL, new Collection[]{returnAlphabet});
        this.internalAlphabet = internalAlphabet;
        this.callAlphabet = callAlphabet;
        this.returnAlphabet = returnAlphabet;
    }

    public Alphabet<I> getCallAlphabet() {
        return this.callAlphabet;
    }

    public I getCallSymbol(int index) {
        return (I)this.callAlphabet.getSymbol(index);
    }

    public int getCallSymbolIndex(I symbol) {
        return this.callAlphabet.getSymbolIndex(symbol);
    }

    public int getNumCalls() {
        return this.callAlphabet.size();
    }

    public Alphabet<I> getInternalAlphabet() {
        return this.internalAlphabet;
    }

    public I getInternalSymbol(int index) {
        return (I)this.internalAlphabet.getSymbol(index);
    }

    public int getInternalSymbolIndex(I symbol) {
        return this.internalAlphabet.getSymbolIndex(symbol);
    }

    public int getNumInternals() {
        return this.internalAlphabet.size();
    }

    public Alphabet<I> getReturnAlphabet() {
        return this.returnAlphabet;
    }

    public I getReturnSymbol(int index) {
        return (I)this.returnAlphabet.getSymbol(index);
    }

    public int getReturnSymbolIndex(I symbol) {
        return this.returnAlphabet.getSymbolIndex(symbol);
    }

    public int getNumReturns() {
        return this.returnAlphabet.size();
    }

    public VPDAlphabet.SymbolType getSymbolType(I symbol) {
        if (this.internalAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.INTERNAL;
        }
        if (this.callAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.CALL;
        }
        if (this.returnAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.RETURN;
        }
        throw new IllegalArgumentException("Symbol is not contained in this alphabet");
    }

    @Override
    public int size() {
        return this.internalAlphabet.size() + this.callAlphabet.size() + this.returnAlphabet.size();
    }

    public I getSymbol(int index) {
        int localIndex = index;
        if (localIndex < this.internalAlphabet.size()) {
            return (I)this.internalAlphabet.getSymbol(localIndex);
        }
        if ((localIndex -= this.internalAlphabet.size()) < this.callAlphabet.size()) {
            return (I)this.callAlphabet.getSymbol(localIndex);
        }
        if ((localIndex -= this.callAlphabet.size()) < this.returnAlphabet.size()) {
            return (I)this.returnAlphabet.getSymbol(localIndex);
        }
        throw new IllegalArgumentException("Index not within its expected bounds");
    }

    public int getSymbolIndex(I symbol) {
        int offset = 0;
        if (this.internalAlphabet.containsSymbol(symbol)) {
            return this.internalAlphabet.getSymbolIndex(symbol);
        }
        offset += this.internalAlphabet.size();
        if (this.callAlphabet.containsSymbol(symbol)) {
            return offset + this.callAlphabet.getSymbolIndex(symbol);
        }
        offset += this.callAlphabet.size();
        if (this.returnAlphabet.containsSymbol(symbol)) {
            return offset + this.returnAlphabet.getSymbolIndex(symbol);
        }
        throw new IllegalArgumentException("Alphabet does not contain the queried symbol");
    }

    public boolean containsSymbol(I symbol) {
        return this.internalAlphabet.containsSymbol(symbol) || this.callAlphabet.containsSymbol(symbol) || this.returnAlphabet.containsSymbol(symbol);
    }

    @SafeVarargs
    private static <I> void validateDisjointness(Collection<I> source, VPDAlphabet.SymbolType type, Collection<I> ... rest) {
        HashSet<I> sourceAsSet = new HashSet<I>(source);
        int initialSize = sourceAsSet.size();
        for (Collection<I> c : rest) {
            sourceAsSet.removeAll(c);
        }
        if (sourceAsSet.size() < initialSize) {
            throw new IllegalArgumentException("The set of " + type + " symbols is not disjoint with the sets of other symbols.");
        }
    }
}

