/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecking.modelchecker;

import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;

public abstract class AbstractUnfoldingModelChecker<I, A, P, L extends Lasso<I, ?>>
implements ModelCheckerLasso<I, A, P, L> {
    private int minimumUnfolds;
    private double multiplier;

    protected AbstractUnfoldingModelChecker(int minimumUnfolds, double multiplier) {
        this.setMinimumUnfolds(minimumUnfolds);
        this.setMultiplier(multiplier);
    }

    public int getMinimumUnfolds() {
        assert (this.minimumUnfolds > 0);
        return this.minimumUnfolds;
    }

    public void setMinimumUnfolds(int minimumUnfolds) {
        if (minimumUnfolds < 1) {
            throw new IllegalArgumentException("must unfold at least once");
        }
        this.minimumUnfolds = minimumUnfolds;
    }

    public void setMultiplier(double multiplier) {
        if (multiplier < 0.0) {
            throw new IllegalArgumentException("multiplier must be >= 0.0");
        }
        this.multiplier = multiplier;
    }

    public double getMultiplier() {
        return this.multiplier;
    }
}

